/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved
 */
package com.fshows.steward.request.trade.item;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author liubo
 * @version FustdAccountInListReq.java, v 0.1 2024-01-02-10:06 上午 liubo
 */
@Data
public class FustdAccountInListReq {


    /**
     * 用户编号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "accountIn长度不能超过30")
    private String accountIn;

    /**
     * 分账金额
     * 分账金额，单位：分
     * (必填)
     */
    @NotNull
    private Integer allocateAmt;

    /**
     * 分账方式
     * 01 分账自动结算， 02 分账记账 不传默认 01
     * (选填)
     */
    @Length(max = 2, message = "allocateType长度不能超过2")
    private String allocateType;

    /**
     * 入账卡号
     * 分账方式为 01 分账自动结算时必传
     * (选填)
     */
    @Length(max = 30, message = "cleanBankNo长度不能超过30")
    private String cleanBankNo;

    /**
     * 发票形式
     * 01 委托代征， 02 个体工商户 开通了税筹的对私入账方可传
     * (选填)
     */
    @Length(max = 2, message = "invoiceType长度不能超过2")
    private String invoiceType;

    /**
     * 打款附言
     * 分账方式为 02 分账记账，打款附言不生效
     * (选填)
     */
    @Length(max = 30, message = "remark长度不能超过30")
    private String remark;

}