/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.steward.request.trade;

import com.fshows.steward.annotation.NoSign;
import lombok.Data;
import org.hibernate.validator.constraints.Length;
import com.fshows.steward.request.FuStewardBizRequest;
import javax.validation.constraints.NotNull;

import javax.validation.constraints.NotBlank;

/**
 * 分账回退接口
 *
 * @author
 * @version FuStdTradeAllocateRefundReq.java, v 0.1 2024-01-02 15:22:42
 */
@Data
public class FuStdTradeAllocateRefundReq extends FuStewardBizRequest {

    private static final long serialVersionUID = -2213838555758134715L;


    /**
     * 商户流水号
     * 唯一流水号，商户定义
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "traceNo长度不能超过30")
    private String traceNo;

    /**
     * 源分账交易富友批次号
     * 源分账交易富友批次号
     * (必填)
     */
    @NotBlank
    @Length(max = 12, message = "batchNo长度不能超过12")
    private String batchNo;

    /**
     * 源支付订单号
     * 富友支付参考流水号
     * (选填)
     */
    @Length(max = 12, message = "srcFasSsn长度不能超过12")
    @NoSign
    private String srcFasSsn;

    /**
     * 用户编号
     * 用户编号
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "accountIn长度不能超过30")
    private String accountIn;

    /**
     * 分账回退金额
     * 分账回退金额
     * (必填)
     */
    @NotNull
    private Integer refundAmt;

}