/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.steward.request.trade;

import com.fshows.steward.annotation.NoSign;
import com.fshows.steward.request.trade.item.FustdSubAccountInListReq;
import lombok.Data;
import org.hibernate.validator.constraints.Length;
import com.fshows.steward.request.FuStewardBizRequest;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * 用户间转账记账接口（异步）
 *
 * @author
 * @version FuStdSubAccountInTransferAsynReq.java, v 0.1 2024-01-02 15:58:29
 */
@Data
public class FuStdSubAccountInTransferAsynReq extends FuStewardBizRequest {

    private static final long serialVersionUID = -2213838555498217992L;


    /**
     * 商户流水号
     * 唯一流水号，商户定义
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "traceNo长度不能超过30")
    private String traceNo;

    /**
     * 转出用户编号
     * 转出账户必须属于该商户
     * (必填)
     */
    @NotBlank
    @Length(max = 40, message = "accountOut长度不能超过40")
    private String accountOut;

    /**
     * 转入用户列表
     * 转入账户必须属于该商户
     * (选填)
     */
    @NoSign
    private List<FustdSubAccountInListReq> accountInlist;

}