/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.steward.request.trade;

import com.fshows.steward.annotation.NoSign;
import lombok.Data;
import org.hibernate.validator.constraints.Length;
import com.fshows.steward.request.FuStewardBizRequest;
import javax.validation.constraints.NotNull;

import javax.validation.constraints.NotBlank;

/**
 * 用户委托结算接口
 *
 * @author
 * @version FuStdAccountInDrawoutReq.java, v 0.1 2024-01-02 16:26:53
 */
@Data
public class FuStdAccountInDrawoutReq extends FuStewardBizRequest {

    private static final long serialVersionUID = -2213838555884567612L;


    /**
     * 商户流水号
     * 唯一流水号，商户定义
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "traceNo长度不能超过30")
    private String traceNo;

    /**
     * 入账方（用户）编号
     * 入账方（用户）编号
     * (必填)
     */
    @NotBlank
    @Length(max = 40, message = "accountIn长度不能超过40")
    private String accountIn;

    /**
     * 入账卡号
     * 入账卡号
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "cleanBankNo长度不能超过30")
    private String cleanBankNo;

    /**
     * 发票形式
     * 发票形式
     * (选填)
     */
    @Length(max = 2, message = "invoiceType长度不能超过2")
    @NoSign
    private String invoiceType;

    /**
     * 结算金额
     * 结算金额
     * (必填)
     */
    @NotNull
    private Integer cleanAmt;

    /**
     * 打款附言
     * 打款附言
     * (选填)
     */
    @Length(max = 30, message = "remark长度不能超过30")
    @NoSign
    private String remark;

}