/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.steward.request.trade;

import lombok.Data;
import org.hibernate.validator.constraints.Length;
import com.fshows.steward.request.FuStewardBizRequest;

import javax.validation.constraints.NotBlank;

/**
 * 用户自动结算重跑接口
 *
 * @author
 * @version FuStdAccountInAutoDrawoutRepairReq.java, v 0.1 2024-01-02 16:21:29
 */
@Data
public class FuStdAccountInAutoDrawoutRepairReq extends FuStewardBizRequest {

    private static final long serialVersionUID = -2213838555722577717L;


    /**
     * 商户流水号
     * 唯一流水号，商户定义
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "traceNo长度不能超过30")
    private String traceNo;

    /**
     * 入账方（用户）编号
     * 入账方（用户）编号
     * (必填)
     */
    @NotBlank
    @Length(max = 40, message = "accountIn长度不能超过40")
    private String accountIn;

    /**
     * 源分账返回的富友批次号
     * 源分账返回的富友批次号
     * (必填)
     */
    @NotBlank
    @Length(max = 12, message = "batchNo长度不能超过12")
    private String batchNo;

    /**
     * 入账卡号
     * 可更换入账方已绑定的卡
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "cleanBankNo长度不能超过30")
    private String cleanBankNo;

    /**
     * 打款附言
     * 打款附言
     * (选填)
     */
    @Length(max = 30, message = "remark长度不能超过30")
    private String remark;

}