/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.steward.request.account;

import com.fshows.sdk.core.client.base.definition.IRequestDefinition;
import lombok.Data;
import org.hibernate.validator.constraints.Length;
import com.fshows.steward.request.FuStewardBizRequest;
import javax.validation.constraints.NotNull;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 用户删除接口
 *
 * @author
 * @version FuStdDeteleCustomerReq.java, v 0.1 2023-12-28 14:18:37
 */
@Data
public class FuStdDeteleCustomerReq extends FuStewardBizRequest {

    private static final long serialVersionUID = -2213838555509101022L;


    /**
     * 唯一流水号，商户定义
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "traceNo长度不能超过30")
    private String traceNo;

    /**
     * 用户编号
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "accountIn长度不能超过30")
    private String accountIn;

}