/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved
 */
package com.fshows.fuiou.util;

import cn.hutool.core.util.ArrayUtil;
import com.alibaba.fastjson.JSON;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/**
 * @author liubo
 * @version SignStrUtil.java, v 0.1 2024-01-07-1:34 下午 liubo
 */
public class SignStrUtil {

    public static String getWaitSignStr(Map<String, Object> dataMap, String[] ignoreList) {
        StringBuilder waitSignStr = generateWaitSignStr(dataMap, ignoreList);
        return waitSignStr.toString();
    }


    private static StringBuilder generateWaitSignStr(Map<String, Object> dataMap, String[] ignoreList) {
        //List<Object>  = new LinkedList<List>();

        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> entry : dataMap.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();

            if (StringUtils.equals(key, "sign") ||
                    StringUtils.equals(key, "signature") ||
                    StringUtils.startsWith(key, "reserved") ||
                    ArrayUtil.contains(ignoreList, key)) {
                continue;
            }

//            if (value == null) {
//                continue;
//            }
            value = value == null ? "":value;

            if (value instanceof List) {
                // If the value is a List, convert it to a JSON array string
                List<?> listValue = (List<?>) value;

                if (listValue.isEmpty()) {
                    continue;
                }
                Object item = listValue.get(0);
                // 只有当元素类型不是基础类型时,才递归序列化,如果是基础类型,则使用java原生的tostring方法处理
                if (item instanceof String
                        || item instanceof Integer
                        || item instanceof Long
                        || item instanceof Double
                        || item instanceof BigDecimal
                        || item instanceof Float) {
                    value = new ArrayList<>(listValue);
                } else {
                    List< Map<String, Object>> resultList = new LinkedList<>();
                    for (Object listItem : listValue) {
                        String jsonString = JSON.toJSONString(listItem);
                        Map<String, Object> resultMap = JSON.parseObject(jsonString);
                        Map<String, Object> stringObjectMap = appendJsonArrayItem(resultMap, ignoreList);
                        resultList.add(stringObjectMap);
                    }
                    value = JSON.toJSONString(resultList);
                }
            }

            appendKeyValue(sb, key, String.valueOf(value));
        }
        return sb;
    }

    private static Map<String, Object> appendJsonArrayItem(Map<String, Object> listItemMap, String[] ignoreList) {

        Map<String, Object> treeMap = new TreeMap<>(listItemMap);
        Map<String, Object> resultMap = new TreeMap<>();
        for (Map.Entry<String, Object> listItemEntry : treeMap.entrySet()) {
            String listItemKey = listItemEntry.getKey();
            Object value = listItemEntry.getValue();
            if (!ArrayUtil.contains(ignoreList, listItemKey)) {
                resultMap.put(listItemKey,value);
            }
        }
        return resultMap;
    }

    private static void appendKeyValue(StringBuilder sb, String key, String value) {
        if (sb.length() > 0) {
            sb.append("&");
        }
        sb.append(key).append("=").append(value);
    }

}