/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.fuiou.response.trade.pay;

import com.fshows.fuiou.response.base.FuiouBizResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 *
 *
 * @author
 * @version FuiouPreOrderResponse.java, v 0.1 2023-07-05 11:12:25
 */
@Data
public class FuiouWxAndUnionUserIdResponse extends FuiouBizResponse implements Serializable {

    private static final long serialVersionUID = -401685540303510363L;

    /**
     * 微信分配的公众账号ID
     *
     * (必填)
     */
    @NotBlank(message = "富友api客户端appId不能为空")
    protected String appId;

    /**
     * 微信分配的子商户公众账号ID
     *
     * (选填)
     */
    @NotBlank
    @Length(max = 15, message = "mchntCd长度不能超过15")
    private String subAppid;

    /**
     * 用户在商户appid下的唯一标识
     *
     * (必填)
     */
    @Length(max = 128, message = "openid长度不能超过128")
    private String openid;

    /**
     * 用户在子商户appid下的唯一标识
     *
     * (选填)
     */
    @Length(max = 128, message = "subOpenid长度不能超过128")
    private String subOpenid;
}