/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.fuiou.response.trade.order;

import lombok.Data;
import lombok.EqualsAndHashCode;
import com.fshows.fuiou.response.base.FuiouBizResponse;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;

/**
 *
 *
 * @author
 * @version FuiouRefundQueryResponse.java, v 0.1 2023-07-05 11:34:24
 */
@Data
public class FuiouRefundQueryResponse  extends FuiouBizResponse implements Serializable {

    private static final long serialVersionUID = -2213838555296195387L;


    /**
     * 交易状态 SUCCESS—退款成功 PAYERROR--退款失败
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "transStat长度不能超过32")
    private String transStat;

    /**
     * 富友分配的商户号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 15, message = "mchntCd长度不能超过15")
    private String mchntCd;

    /**
     * 终端号
     *
     * (选填)
     */
    @Length(max = 8, message = "termId长度不能超过8")
    private String termId;

    /**
     * 订单类型:ALIPAY，WECHAT，JD(京东钱包)，QQ(QQ钱包)，UNIONPAY
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 20, message = "orderType长度不能超过20")
    private String orderType;

    /**
     * 商户订单号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "mchntOrderNo长度不能超过30")
    private String mchntOrderNo;

    /**
     * 商户退款单号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "refundOrderNo长度不能超过32")
    private String refundOrderNo;

    /**
     * 渠道交易流水号
     *
     * (选填)
     */
    @Length(max = 32, message = "transactionId长度不能超过32")
    private String transactionId;

    /**
     * 渠道退款流水号
     *
     * (选填)
     */
    @Length(max = 32, message = "refundId长度不能超过32")
    private String refundId;

    /**
     * 富友交易日期
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 8, message = "reservedFySettleDt长度不能超过8")
    private String reservedFySettleDt;

    /**
     * 富友系统内部追踪号
     *
     * (选填)
     */
    @Length(max = 12, message = "reservedFyTraceNo长度不能超过12")
    private String reservedFyTraceNo;

    /**
     * 退款金额
     *
     * (选填)
     */
    private Integer reservedRefundAmt;

    /**
     * 优惠信息
     *
     * (选填)
     */
    private String reservedPromotionDetail;

}