/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.fuiou.response.merchant;

import com.fshows.fuiou.response.base.FuiouBizResponse;
import lombok.Data;

import java.io.Serializable;

/**
 * @author
 * @version FuiouAuditQueryResponse.java, v 0.1 2023-09-16 09:32:01
 */
@Data
public class FuiouAuditQueryResponse extends FuiouBizResponse implements Serializable {

    private static final long serialVersionUID = -2213838555722763554L;


    /**
     * 唯一流水号
     * (选填)
     */
    private String traceNo;

    /**
     * 返回码 0000：查询成功 -1：失败 9999：系统异常
     * (必填)
     */
    private String retCode;

    /**
     * 返回信息
     * (必填)
     */
    private String retMsg;

    /**
     * 变更单号
     * (必填)
     */
    private String modifyNo;

    /**
     * 变更状态 00 已拒绝 01 已创建待提交 02 已提交待审核 03 已审核待批准 08 待渠道处理 04 已处理完成
     * (必填)
     */
    private String modifySt;

    /**
     * 变更状态描述，见状态中文描述
     * (必填)
     */
    private String modifyStDesc;

    /**
     * 变更处理意见
     * (必填)
     */
    private String modifyDealMsg;

    /**
     * 银联商户号 （当变更类型为YL，并且变更状态为01时这个字段才有返回） 微信、支付宝子商户号
     * (选填)
     */
    private String cupAssMchntCd;

}