/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.fuiou.request.settlement;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.fuiou.enums.settlement.FuiouSettlementApiDefinitionEnum;
import com.fshows.fuiou.request.base.FuiouBizRequest;
import com.fshows.fuiou.response.settlement.FuiouQuerySettlementListResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author wangyi
 * @version QuerySettlementListRequest.java, v 0.1 2023-09-25 14:17 wangyi
 */
@Data
public class FuiouQuerySettlementListRequest extends FuiouBizRequest<FuiouQuerySettlementListResponse, FuiouSettlementApiDefinitionEnum> implements Serializable {

    private static final long serialVersionUID = 7919309650360371048L;

    /**
     * 商户号, 富友分配给二级商户的商户号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 15, message = "mchntCd长度不能超过15")
    @JSONField(name = "mchnt_cd")
    private String mchntCd;

    @NotBlank(message="查询开始日期不能为空")
    @JSONField(name = "start_date")
    private String startDate;

    @NotBlank(message="查询结束日期不能为空")
    @JSONField(name = "end_date")
    private String endDate;

    @NotBlank(message="分页开始序号不能为空")
    @JSONField(name = "start_index")
    private String startIndex;

    @NotBlank(message="分页结束序号不能为空")
    @JSONField(name = "end_index")
    private String endIndex;
}