/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.fuiou.request.merchant;

import com.fshows.fuiou.enums.merchant.FuiouMerchantApiDefinitionEnum;
import com.fshows.fuiou.request.base.FuiouBizRequest;
import com.fshows.fuiou.response.merchant.FuiouMerchantUpdateResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author
 * @version FuiouMerchantUpdateRequest.java, v 0.1 2023-09-16 09:32:01
 */
@Data
public class FuiouMerchantUpdateRequest extends FuiouBizRequest<FuiouMerchantUpdateResponse, FuiouMerchantApiDefinitionEnum> implements Serializable {

    private static final long serialVersionUID = -2213838555652092673L;


    /**
     * 唯一流水号
     * (必填)
     */
    @NotBlank
    @Length(max = 12, message = "traceNo长度不能超过12")
    private String traceNo;

    /**
     * 已在富友入网的富友商户代码
     * (必填)
     */
    @NotBlank
    @Length(max = 15, message = "fyMchntCd长度不能超过15")
    private String fyMchntCd;

    /**
     * 二级代理机构号
     * (选填)
     */
    @Length(max = 13, message = "subInsCd长度不能超过13")
    private String subInsCd;

    /**
     * 商户全称，不能有特殊字符，仅可包含汉字、数字、字母
     * (选填)
     */
    @Length(max = 50, message = "mchntName长度不能超过50")
    private String mchntName;

    /**
     * 商户简称，不能超过，不能有特殊字符，仅可包含汉字、数字、字母
     * (选填)
     */
    @Length(max = 20, message = "mchntShortname长度不能超过20")
    private String mchntShortname;

    /**
     * 商户真实名称(与营业执照上相同)
     * (选填)
     */
    @Length(max = 50, message = "realName长度不能超过50")
    private String realName;

    /**
     * 挂靠商户号
     * (选填)
     */
    @Length(max = 15, message = "linkMchntCd长度不能超过15")
    private String linkMchntCd;

    /**
     * 证件类型： 0 企业商户：营业执照（license_no填15位长的营业执照编号） 1 企业商户：三证合一（license_no填18位长的三证合一营业执照编号） A 小微商户：身份证(一证下机) B 个体户工商户（个体工商户不论证件是营业执照还是三证合一都传 B） 2 事业单位
     * (选填)
     */
    @Length(max = 1, message = "licenseType长度不能超过1")
    private String licenseType;

    /**
     * 证件号码，填写方法： 1.license_type=0 或 1 或 2，此处填写营业执照号码。 2.license_type=A，此处填写身份证号码 3.license_type=B，此处填写个体工商户营业执照号码
     * (选填)
     */
    @Length(max = 20, message = "licenseNo长度不能超过20")
    private String licenseNo;

    /**
     * 证件到期日（格式yyyyMMdd） 长期请填20991231，无有效期请填19000101 1.license_type=0 或 1 或 2，此处填写营业执照到期日。 2.license_type=A，此处填写身份证的到期日 3.license_type=B，此处填写个体工商户营业执照号的到期日
     * (选填)
     */
    @Length(max = 8, message = "licenseExpireDt长度不能超过8")
    private String licenseExpireDt;

    /**
     * 法人身份证号
     * (选填)
     */
    @Length(max = 20, message = "certifId长度不能超过20")
    private String certifId;

    /**
     * 法人身份证到期日（格式 YYYYMMDD）
     * (选填)
     */
    @Length(max = 8, message = "certifIdExpireDt长度不能超过8")
    private String certifIdExpireDt;

    /**
     * 商户经营地市代码 见附件6.省市区代码对照表
     * (选填)
     */
    @Length(max = 4, message = "cityCd长度不能超过4")
    private String cityCd;

    /**
     * 商户经营地区县代码（必须属于 city_cd 所辖） 见附件6.省市区代码对照表
     * (选填)
     */
    @Length(max = 4, message = "countyCd长度不能超过4")
    private String countyCd;

    /**
     * 联系人姓名（不能有特殊字符）
     * (选填)
     */
    @Length(max = 10, message = "contactPerson长度不能超过10")
    private String contactPerson;

    /**
     * 客服电话
     * (选填)
     */
    @Length(max = 15, message = "contactPhone长度不能超过15")
    private String contactPhone;

    /**
     * 商户经营地联系地址
     * (选填)
     */
    @Length(max = 50, message = "contactAddr长度不能超过50")
    private String contactAddr;

    /**
     * 联系电话（必须真实手机号）
     * (选填)
     */
    @Length(max = 11, message = "contactMobile长度不能超过11")
    private String contactMobile;

    /**
     * 联系邮箱
     * (选填)
     */
    @Length(max = 60, message = "contactEmail长度不能超过60")
    private String contactEmail;

    /**
     * 经营范围代码（新开户则必填） 见附件4.微信经营范围代码
     * (选填)
     */
    @Length(max = 4, message = "business长度不能超过4")
    private String business;

    /**
     * 入账卡类型：1：对公；2：对私;
     * (选填)
     */
    @Length(max = 1, message = "acntType长度不能超过1")
    private String acntType;

    /**
     * 行别,（acnt_type=1 必填）(参考行别对照表) 见附件7.行别对照表
     * (选填)
     */
    @Length(max = 4, message = "bankType长度不能超过4")
    private String bankType;

    /**
     * 入账卡开户行联行号 见附件9.开户行信息列表
     * (选填)
     */
    @Length(max = 12, message = "interBankNo长度不能超过12")
    private String interBankNo;

    /**
     * 入账卡开户行名称，在联行号找不到时生效）
     * (选填)
     */
    @Length(max = 50, message = "issBankNm长度不能超过50")
    private String issBankNm;

    /**
     * 入账卡户名 1. 如果 license_type=A，acnt_nm=artif_nm 即小微商户身份证入网须入账法人 2. 如果 acnt_type=2 且acnt_artif_flag=1，则 acnt_nm=artif_nm 即对私且法人入账，则入账卡户名和法人姓名一致 3. 如果 acnt_type=1 且acnt_artif_flag=1，则 acnt_nm=real_name 即对公且法人入账，则入账卡户名和营业执照上商户名一致
     * (选填)
     */
    @Length(max = 40, message = "acntNm长度不能超过40")
    private String acntNm;

    /**
     * 入账卡号（不带长度位）
     * (选填)
     */
    @Length(max = 40, message = "acntNo长度不能超过40")
    private String acntNo;

    /**
     * 法人姓名 （如果 acnt_type=2 且acnt_artif_flag=1，则 acnt_nm=artif_nm 即对私且法人入账，则入账卡户名和法人姓名一致）
     * (选填)
     */
    @Length(max = 15, message = "artifNm长度不能超过15")
    private String artifNm;

    /**
     * 法人入账标识 0 :非法人入账，1：法人入账 若变更时，license_type 不为空，此字段必填
     * (选填)
     */
    @Length(max = 1, message = "acntArtifFlag长度不能超过1")
    private String acntArtifFlag;

    /**
     * 入账证件类型("0":"身份证", "1":"护照","2":"军官证","3":"士兵证","4":"回乡证","5":"户口本","6":"外国护照","7":"其它" ) 【acnt_artif_flag = 0 时必填】
     * (选填)
     */
    @Length(max = 1, message = "acntCertifTp长度不能超过1")
    private String acntCertifTp;

    /**
     * 入账证件号 【acnt_artif_flag = 0时必填】 1.如果 license_type=A，则acnt_certif_id =license_no 即小微商户身份证入网须入账人身份证号码即法人身份证号码 2.如果 acnt_type=2 且acnt_artif_flag=1，则acnt_certif_id =certif_id 即对私且法人入账，则入账卡人身份证号码和法人身份证号码一致
     * (选填)
     */
    @Length(max = 20, message = "acntCertifId长度不能超过20")
    private String acntCertifId;

    /**
     * 入账证件到期日（格式 yyyyMMdd）
     * (选填)
     */
    @Length(max = 8, message = "acntCertifExpireDt长度不能超过8")
    private String acntCertifExpireDt;

    /**
     * 退货标识(0：不能退货，1：可以退货)
     * (选填)
     */
    @Length(max = 1, message = "thFlag长度不能超过1")
    private String thFlag;

    /**
     * 微信支付标识（0：不开通，1：开通）
     * (选填)
     */
    @Length(max = 1, message = "wxFlag长度不能超过1")
    private String wxFlag;

    /**
     * 微信扣率套餐代码
     * (选填)
     */
    @Length(max = 5, message = "wxSetCd长度不能超过5")
    private String wxSetCd;

    /**
     * 支付宝支付标识（0：不开通，1：开通）
     * (选填)
     */
    @Length(max = 1, message = "aliFlag长度不能超过1")
    private String aliFlag;

    /**
     * 支付宝扣率套餐代码
     * (选填)
     */
    @Length(max = 5, message = "aliSetCd长度不能超过5")
    private String aliSetCd;

    /**
     * 资金增值服务【小宝理财】（0：不开通【默认】，1：开通）
     * (选填)
     */
    @Length(max = 1, message = "autoBuy长度不能超过1")
    private String autoBuy;

    /**
     * QQ钱包支付标识（0：不开通【默认】，1：开通）
     * (选填)
     */
    @Length(max = 1, message = "qpayFlag长度不能超过1")
    private String qpayFlag;

    /**
     * QQ钱包扣率套餐代码 （默认取wx_set_cd）
     * (选填)
     */
    @Length(max = 5, message = "qpaySetCd长度不能超过5")
    private String qpaySetCd;

    /**
     * JD钱包支付标识（0：不开通【默认】，1：开通）
     * (选填)
     */
    @Length(max = 1, message = "jdpayFlag长度不能超过1")
    private String jdpayFlag;

    /**
     * JD钱包扣率套餐代码 （默认取wx_set_cd）
     * (选填)
     */
    @Length(max = 5, message = "jdpaySetCd长度不能超过5")
    private String jdpaySetCd;

    /**
     * 天天结 D1 标识（0：不开通【默认】，1：开通） (此字段将会废弃，请使用 settle_tp 字段(值为 3))
     * (选填)
     */
    @Length(max = 1, message = "dailySettleFlag长度不能超过1")
    private String dailySettleFlag;

    /**
     * 天天结 D1 扣率套餐代码 （daily_settle_flag ==1 时必填） (此字段将会废弃，请使用settle_tp_cd 字段)(使用d0扣率模板)
     * (选填)
     */
    @Length(max = 5, message = "dailySettleSetCd长度不能超过5")
    private String dailySettleSetCd;

    /**
     * 清算类型： 1 自动结算（T1）； 2 手动结算； 3 自动结算（D1）； 4 定时结算
     * (选填)
     */
    @Length(max = 1, message = "settleTp长度不能超过1")
    private String settleTp;

    /**
     * 清算类型扣率套餐代码(settle_tp==3必填)
     * (选填)
     */
    @Length(max = 5, message = "settleTpCd长度不能超过5")
    private String settleTpCd;

    /**
     * 清算时间，08-23 (settle_tp==4 时必填)
     * (选填)
     */
    @Length(max = 2, message = "settleTs长度不能超过2")
    private String settleTs;

    /**
     * 联系人身份证号(9月10日后必填)
     * (选填)
     */
    @Length(max = 18, message = "contactCertNo长度不能超过18")
    private String contactCertNo;

    /**
     * 营业执照开始时间(9月10日后必填)
     * (选填)
     */
    @Length(max = 8, message = "licenseStartDt长度不能超过8")
    private String licenseStartDt;

    /**
     * 营业执照注册地址(9月10日后必填)
     * (选填)
     */
    @Length(max = 50, message = "licRegisAddr长度不能超过50")
    private String licRegisAddr;

    /**
     * 法人身份证开始时间(9月10日后必填)
     * (选填)
     */
    @Length(max = 8, message = "cardStartDt长度不能超过8")
    private String cardStartDt;

    /**
     * 所属银行
     * (选填)
     */
    @Length(max = 30, message = "connInsCd长度不能超过30")
    private String connInsCd;

    /**
     * 客户经理
     * (选填)
     */
    @Length(max = 30, message = "customerManage长度不能超过30")
    private String customerManage;

    /**
     * 支付宝MCC
     * (选填)
     */
    @Length(max = 4, message = "aliMcc长度不能超过4")
    private String aliMcc;

    /**
     * 法人手机号
     * (必填)
     */
    @Length(max = 11, message = "certifPhone长度不能超过11")
    private String certifPhone;

    /**
     * 法人身份证地址
     * (必填)
     */
    @Length(max = 50, message = "certifAddr长度不能超过50")
    private String certifAddr;

}