/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.fuiou.request.merchant;

import com.fshows.fuiou.enums.merchant.FuiouMerchantApiDefinitionEnum;
import com.fshows.fuiou.request.base.FuiouBizRequest;
import com.fshows.fuiou.response.merchant.FuiouBaseInfoUpdateResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author
 * @version FuiouBaseInfoUpdateRequest.java, v 0.1 2024-05-08 11:47:31
 */
@Data
public class FuiouBaseInfoUpdateRequest extends FuiouBizRequest<FuiouBaseInfoUpdateResponse, FuiouMerchantApiDefinitionEnum> implements Serializable {

    private static final long serialVersionUID = -2213838555420830253L;


    /**
     * 唯一流水号
     * (必填)
     */
    @NotBlank
    @Length(max = 12, message = "traceNo长度不能超过12")
    private String traceNo;

    /**
     * 已在富友入网的富友商户代码
     * (必填)
     */
    @NotBlank
    @Length(max = 15, message = "fyMchntCd长度不能超过15")
    private String fyMchntCd;

    /**
     * 二级代理机构号
     * (选填)
     */
    @Length(max = 13, message = "subInsCd长度不能超过13")
    private String subInsCd;

    /**
     * 不能有特殊字符，仅可包含汉字、数字、字母
     * (选填)
     */
    @Length(max = 50, message = "mchntName长度不能超过50")
    private String mchntName;

    /**
     * 商户英文名称
     * (选填)
     */
    @Length(max = 160, message = "mchntEnName长度不能超过160")
    private String mchntEnName;

    /**
     * 商户简称不能超过，不能有特殊字符，仅可包含汉字、数字、字母。
     * (选填)
     */
    @Length(max = 20, message = "mchntShortname长度不能超过20")
    private String mchntShortname;

    /**
     * 商户英文简称
     * (选填)
     */
    @Length(max = 40, message = "mchntEnShortname长度不能超过40")
    private String mchntEnShortname;

    /**
     * 商户真实名称（与营业执照上相同）
     * (选填)
     */
    @Length(max = 50, message = "realName长度不能超过50")
    private String realName;

    /**
     * 品牌名称
     * (选填)
     */
    @Length(max = 50, message = "platNameCn长度不能超过50")
    private String platNameCn;

    /**
     * 经营范围
     * (选填)
     */
    @Length(max = 60, message = "tradeDesc长度不能超过60")
    private String tradeDesc;

    /**
     * 证件类型：0营业执照，1三证合一，A身份证（一证下机）B 个体户，2事业单位
     * (选填)
     */
    @Length(max = 1, message = "licenseType长度不能超过1")
    private String licenseType;

    /**
     * 证件号码，填写方法：1.license_type=0或1，此处填写营业执照号码。2.license_type=A，此处填写身份证号码3.license_type=B，此处填写个体工商户营业执照号码
     * (选填)
     */
    @Length(max = 20, message = "licenseNo长度不能超过20")
    private String licenseNo;

    /**
     * 证件到期日（格式YYYYMMDD）格式长期请填20991231 无有效期请填 190001011.license_type=0或1，此处填写营业执照到期日。2.license_type=A此处填写身份证的到期日3.license_type=B，此处填写个体工商户营业执照号的到期日
     * (选填)
     */
    @Length(max = 8, message = "licenseExpireDt长度不能超过8")
    private String licenseExpireDt;

    /**
     * 营业执照开始时间
     * (选填)
     */
    @Length(max = 8, message = "licenseStartDt长度不能超过8")
    private String licenseStartDt;

    /**
     * 注册地址
     * (选填)
     */
    @Length(max = 60, message = "licRegisAddr长度不能超过60")
    private String licRegisAddr;

    /**
     * 注册资金
     * (选填)
     */
    @Length(max = 10, message = "regCapital长度不能超过10")
    private String regCapital;

    /**
     * 组织机构代码证
     * (选填)
     */
    @Length(max = 32, message = "zzjgdmzNo长度不能超过32")
    private String zzjgdmzNo;

    /**
     * 组织机构代码证到期时间
     * (选填)
     */
    @Length(max = 8, message = "zzjgdmzExpireDt长度不能超过8")
    private String zzjgdmzExpireDt;

    /**
     * 税务登记证
     * (选填)
     */
    @Length(max = 32, message = "taxNo长度不能超过32")
    private String taxNo;

    /**
     * 税务登记证到期时间
     * (选填)
     */
    @Length(max = 8, message = "taxDt长度不能超过8")
    private String taxDt;

    /**
     * 法人身份证号
     * (选填)
     */
    @Length(max = 20, message = "certifId长度不能超过20")
    private String certifId;

    /**
     * 法人身份证到期日（格式YYYYMMDD）
     * (选填)
     */
    @Length(max = 8, message = "certifIdExpireDt长度不能超过8")
    private String certifIdExpireDt;

    /**
     * 法人身份证开始时间
     * (选填)
     */
    @Length(max = 8, message = "cardStartDt长度不能超过8")
    private String cardStartDt;

    /**
     * 法人姓名
     * (选填)
     */
    @Length(max = 10, message = "artifNm长度不能超过10")
    private String artifNm;

    /**
     * 法人证件类型
     * (选填)
     */
    @Length(max = 1, message = "artifTp长度不能超过1")
    private String artifTp;

    /**
     * 法人手机号
     * (选填)
     */
    @Length(max = 11, message = "certifPhone长度不能超过11")
    private String certifPhone;

    /**
     * 联系人姓名
     * (选填)
     */
    @Length(max = 10, message = "contactPerson长度不能超过10")
    private String contactPerson;

    /**
     * 客服电话
     * (选填)
     */
    @Length(max = 15, message = "contactPhone长度不能超过15")
    private String contactPhone;

    /**
     * 联系电话（必须真实手机号）
     * (选填)
     */
    @Length(max = 11, message = "contactMobile长度不能超过11")
    private String contactMobile;

    /**
     * 联系邮箱
     * (选填)
     */
    @Length(max = 30, message = "contactEmail长度不能超过30")
    private String contactEmail;

    /**
     * 联系地址
     * (选填)
     */
    @Length(max = 50, message = "contactAddr长度不能超过50")
    private String contactAddr;

    /**
     * 联系人身份证号
     * (选填)
     */
    @Length(max = 18, message = "contactCertNo长度不能超过18")
    private String contactCertNo;

    /**
     * 联系人身份证到期日
     * (选填)
     */
    @Length(max = 8, message = "contactExpireDt长度不能超过8")
    private String contactExpireDt;

    /**
     * 变更描述即变更备注，富友在审核时，可以看到的文字描述
     * (选填)
     */
    @Length(max = 80, message = "modifyDesc长度不能超过80")
    private String modifyDesc;

}