/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.fuiou.request.merchant;

import com.fshows.fuiou.enums.merchant.FuiouMerchantApiDefinitionEnum;
import com.fshows.fuiou.request.base.FuiouBizRequest;
import com.fshows.fuiou.response.merchant.FuiouAuditQueryResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author
 * @version FuiouAuditQueryRequest.java, v 0.1 2023-09-16 09:32:01
 */
@Data
public class FuiouAuditQueryRequest extends FuiouBizRequest<FuiouAuditQueryResponse, FuiouMerchantApiDefinitionEnum> implements Serializable {

    private static final long serialVersionUID = -2213838555517703000L;


    /**
     * 唯一流水号
     * (必填)
     */
    @NotBlank
    @Length(max = 12, message = "traceNo长度不能超过12")
    private String traceNo;

    /**
     * 商户号
     * (必填)
     */
    @NotBlank
    @Length(max = 15, message = "mchntCd长度不能超过15")
    private String mchntCd;

    /**
     * 变更单号
     * (必填)
     */
    @NotBlank
    @Length(max = 9, message = "modifyNo长度不能超过9")
    private String modifyNo;

    /**
     * 变更类型： TZ（D0 业务） YL（银联二维码） LA（分账） PA（扫码预授权） HH（红火计划类型） RZ：入账信息 BS：商户基本信息变更 JS：结算方式变更 SM：扫码常规变更 SD：收单常规变更 A2 : 支付宝特殊费率 SP：微信特殊渠道申请
     * (必填)
     */
    @NotBlank
    @Length(max = 2, message = "modifyTp长度不能超过2")
    private String modifyTp;

}