/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.fuiou.request.fgj;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.fuiou.enums.fgj.FuiouFgjApiDefinitionEnum;
import com.fshows.fuiou.request.base.FuiouBizRequest;
import com.fshows.fuiou.response.fgj.FuiouFgjImgUploadResponse;
import com.fshows.steward.annotation.NoSign;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;

/**
 * @author
 * @version FgjCreateRequest.java, v 0.1 2023-09-16 09:32:01
 */
@Data
public class FuiouFgjImgUploadRequest extends FuiouBizRequest<FuiouFgjImgUploadResponse, FuiouFgjApiDefinitionEnum> implements Serializable {

    private static final long serialVersionUID = 1821756248310554030L;
    /**
     * 唯一流水号，机构自己定义
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "traceNo长度不能超过64")
    @JSONField(name = "trace_no")
    private String traceNo;

    /**
     * 商户号
     */
    @NotBlank
    @Length(max = 15, message = "mchntCd长度不能超过15")
    @JSONField(name = "mchnt_cd")
    private String mchntCd;

    /**
     * 打款凭证照片
     * 图片上传接口返回的对应media_id
     */
    @Length(max = 40, message = "dkpzImgId长度不能超过40")
    @JSONField(name = "dkpz_img_id")
    private String dkpzImgId;

    /**
     * 委托打款凭证照片
     * 图片上传接口返回的对应media_id
     */
    @Length(max = 40, message = "wtdkpzImgId长度不能超过40")
    @JSONField(name = "wtdkpz_img_id")
    private String wtdkpzImgId;
    /**
     * 合同扫描照片或压缩包
     * 图片上传接口返回的对应media_id
     */
    @Length(max = 40, message = "htZipImgId长度不能超过40")
    @JSONField(name = "ht_zip_img_id")
    private String htZipImgId;
    /**
     * 营业执照照片
     * 图片上传接口返回的对应media_id
     */
    @Length(max = 40, message = "licImgId长度不能超过40")
    @JSONField(name = "lic_img_id")
    private String licImgId;
    /**
     * 法人身份证（正面）扫描照片
     * 图片上传接口返回的对应media_id
     */
    @Length(max = 40, message = "certifZmImgId长度不能超过40")
    @JSONField(name = "certif_zm_img_id")
    private String certifZmImgId;
    /**
     * 法人身份证（反面）扫描照片
     * 图片上传接口返回的对应media_id
     */
    @Length(max = 40, message = "certifFmImgId长度不能超过40")
    @JSONField(name = "certif_fm_img_id")
    private String certifFmImgId;
    /**
     * 组织机构代码证扫描照片
     * 图片上传接口返回的对应media_id
     */
    @Length(max = 40, message = "zzjgdmzImgId长度不能超过40")
    @JSONField(name = "zzjgdmz_img_id")
    private String zzjgdmzImgId;
    /**
     * 税务登记证扫描照片
     * 图片上传接口返回的对应media_id
     */
    @Length(max = 40, message = "taxImgId长度不能超过40")
    @JSONField(name = "tax_img_id")
    private String taxImgId;
    /**
     * 开户许可证扫描照片
     * 图片上传接口返回的对应media_id
     */
    @Length(max = 40, message = "khxkzImgId长度不能超过40")
    @JSONField(name = "khxkz_img_id")
    private String khxkzImgId;
    /**
     * 银行卡正面扫描照片
     * 图片上传接口返回的对应media_id
     */
    @Length(max = 40, message = "yhkImgId长度不能超过40")
    @JSONField(name = "yhk_img_id")
    private String yhkImgId;
    /**
     * 入网调查函
     * 图片上传接口返回的对应media_id
     */
    @Length(max = 40, message = "rwdchImgId长度不能超过40")
    @JSONField(name = "rwdch_img_id")
    private String rwdchImgId;
    /**
     * 公司照片
     * 图片上传接口返回的对应media_id
     */
    @Length(max = 40, message = "companyImgId长度不能超过40")
    @JSONField(name = "company_img_id")
    private String companyImgId;
    /**
     * 其它照片
     * 图片上传接口返回的对应media_id
     */
    @Length(max = 40, message = "otherImgId长度不能超过40")
    @JSONField(name = "other_img_id")
    private String otherImgId;
    /**
     * 其它照片2
     * 图片上传接口返回的对应media_id
     */
    @Length(max = 40, message = "other2ImgId长度不能超过40")
    @JSONField(name = "other2_img_id")
    private String other2ImgId;

    /**
     * 其它照片3
     * 图片上传接口返回的对应media_id
     */
    @Length(max = 40, message = "other3ImgId长度不能超过40")
    @JSONField(name = "other3_img_id")
    private String other3ImgId;

    /**
     * 联系人身份证(国徽面)扫描照片
     * 图片上传接口返回的对应media_id
     */
    @Length(max = 40, message = "contactZmImgId长度不能超过40")
    @JSONField(name = "contact_zm_img_id")
    private String contactZmImgId;

    /**
     * 联系人身份证(人像面)扫描照片
     * 图片上传接口返回的对应media_id
     */
    @Length(max = 40, message = "contactFmImgId长度不能超过40")
    @JSONField(name = "contact_fm_img_id")
    private String contactFmImgId;

    /**
     * 受益人身份证照片
     */
    @NoSign
    @JSONField(name = "bene_img_ids")
    private List<FuiouFgjBeneImgUploadRequest> beneImgIds;

    /**
     * 受益人身份证照片
     */
    @NoSign
    @JSONField(name = "sharehold_img_ids")
    private List<FuiouFgjShareHoldImgUploadRequest> shareholdImgIds;

    /**
     * cfca授权书
     * 图片上传接口返回的对应media_id
     */
    @Length(max = 40, message = "cfcaImgId长度不能超过40")
    @JSONField(name = "cfca_img_id")
    private String cfcaImgId;


}