/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.fuiou.request.fgj;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;

/**
 * @author zhoujp
 * @version FuiouFgjBeneImgUploadRequest.java, v 0.1 2024-07-23 15:45 zhoujp
 */
@Data
public class FuiouFgjBeneImgUploadRequest implements Serializable {
    private static final long serialVersionUID = -8833324972498320223L;

    /**
     * 证件号码
     */
    @Length(max = 24, message = "beneCertifNo长度不能超过24")
    @JSONField(name = "bene_certif_no")
    private String beneCertifNo;

    /**
     * 国徽面-扫描照片
     * 图片上传接口返回的对应media_id
     */
    @Length(max = 40, message = "beneZmImgId长度不能超过40")
    @JSONField(name = "bene_zm_img_id")
    private String beneZmImgId;

    /**
     * 人像面-扫描照片
     * 图片上传接口返回的对应media_id
     */
    @Length(max = 40, message = "beneFmImgId长度不能超过40")
    @JSONField(name = "bene_fm_img_id")
    private String beneFmImgId;
}