package com.fshows.fuiou.request.bank;

import lombok.Data;

@Data
public class OpenCardSdkRequest extends BankActivitySdkRequest {

    /**
     * 商户号
     */
    private String mchntCd;
    /**
     * 开卡银行机构号
     */
    private String cardBankInsCd;
    /**
     * 银行客户经理—开卡银行报备选择客户经理时必填
     */
    private String bankUserName;
    /**
     * 经营范围——参数为空时默认取商户经营范围
     */
    private String tradeDesc;
    /**
     * 拓展类型（01-代理拓展；  02-银行拓展）开卡银行报备选择拓展类型时必填
     */
    private String expType;
    /**
     * 月流水（万）——所属银行报备选择月流水时必填
     */
    private String monthJournal;
    /**
     * 商户联系人——参数为空时默认取商户信息的联系人
     */
    private String contactPerson;
    /**
     * 商户联系电话，支持座机和手机号，座机需带区号，用-与号码分开参数为空时默认取商户信息的联系电话
     */
    private String contactMobile;
    /**
     * 代理联系方式——参数为空时默认取商户代理联系方式
     */
    private String relateContactMobile;
    /**
     * 业务员联系方式——参数为空时默认取业务员联系方式
     */
    private String ywyMobileNo;
    /**
     * 商户联系地址——参数为空时默认取商户联系地址
     */
    private String contactAddr;
    /**
     * 意愿开户类型(G-对公；S-对私)—开卡银行报备选择意愿开户类型时必填
     */
    private String wishCardType;
    /**
     * 门店名称—开卡银行报备选择门店名称时必填
     */
    private String tmGroupName;
    /**
     * 门店地址—开卡银行报备选择门店名称时必填
     */
    private String shopAddr;
    /**
     * 备注
     */
    private String remark;
}
