/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.fuiou.client.impl;

import cn.hutool.core.util.RandomUtil;
import com.fshows.fuiou.client.base.ApiClientConfig;
import com.fshows.fuiou.client.base.IFuiouApiDefinition;
import com.fshows.fuiou.client.base.IHttpRequest;
import com.fshows.fuiou.client.base.ISigner;
import com.fshows.fuiou.client.base.SignParam;
import com.fshows.fuiou.exception.FuiouApiException;
import com.fshows.fuiou.request.base.FuiouBizRequest;
import com.fshows.fuiou.response.base.FuiouBizResponse;
import com.fshows.fuiou.util.FuiouRequestUtils;
import com.fshows.fuiou.util.LogUtil;
import lombok.extern.slf4j.Slf4j;

import java.util.Map;

/**
 * @author zhubo
 * @version MerchantFuiouApiClientImpl.java, v 0.1 2023-09-11 11:10 zhubo
 */
@Slf4j
public class FuiouFgjApiXmlClientImpl extends AbstractFuiouApiClientImpl {

    public FuiouFgjApiXmlClientImpl(ApiClientConfig apiClientConfig) throws FuiouApiException {
        super(apiClientConfig, new DefaultHttpRequestImpl(), new FuiouFgjSignerImpl());
    }

    public FuiouFgjApiXmlClientImpl(ApiClientConfig apiClientConfig, IHttpRequest httpRequest, ISigner signer) throws FuiouApiException {
        super(apiClientConfig, httpRequest, signer);
    }

    @Override
    public <T extends FuiouBizResponse, R extends IFuiouApiDefinition> T execute(FuiouBizRequest<T, R> request, R merchantApiDefinitionEnum) throws FuiouApiException {
        return (T) super.doExecute(request, merchantApiDefinitionEnum);
    }

    @Override
    protected FuiouBizRequest buildFuiouBizRequest(FuiouBizRequest request, IFuiouApiDefinition tradeApiDefinitionEnum) {
        // 补充参数
        request.setInsCd(apiClientConfig.getAppId());
        return request;
    }

    @Override
    protected SignParam buildSignParam(FuiouBizRequest baseRequest) {
        SignParam signParam = new SignParam();
        signParam.setAppid(apiClientConfig.getAppId());
        signParam.setNonceStr(RandomUtil.randomString(12));
        signParam.setRequest(baseRequest);
        return signParam;
    }

    @Override
    protected String serializableRequest(FuiouBizRequest fuiouBaseRequest, String sign, IFuiouApiDefinition tradeApiDefinitionEnum) {
        Map<String, Object> requstMap = FuiouRequestUtils.ObjectToMapFgj(fuiouBaseRequest);
        return FuiouRequestUtils.generateXmlByObjectMap(requstMap);
    }

    @Override
    protected FuiouBizResponse parseResponse(String resBody, IFuiouApiDefinition merchantApiDefinitionEnum) throws FuiouApiException {
        try {
            Map<String, String> resMap = FuiouRequestUtils.getMapFromXML(resBody);
            FuiouBizResponse fuiouBizResponse = FuiouRequestUtils.getObjectFromMap(resMap, merchantApiDefinitionEnum.getResponseClass());
            fuiouBizResponse.setResMap(resMap);
            return fuiouBizResponse;
        } catch (Exception e) {
            LogUtil.error(log, "【fuiou-sdk】响应结果反序列化异常 >> resBody={}", e, resBody);
            throw new FuiouApiException("[fuiou-sdk]响应结果反序列化异常");
        }
    }
}
