/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.fuiou.client.base;

import com.fshows.fuiou.request.base.FuiouBizRequest;
import com.fshows.fuiou.response.base.FuiouBizResponse;

/**
 * 富友API资源定义
 * <p>
 * 目前API资源采用enum方式定义
 *
 * @author liluqing
 * @version IFuiouApiDefinition.java, v 0.1 2022-03-01 20:24
 */
public interface IFuiouApiDefinition {

    /**
     * 获取url资源子路径
     * 例如: 接口的URL是 “https://s2.lakala.com/api/v3/labs/trans/preorder”
     * ,则ApiSubPath则是域名后的部分内容“/api/v3/labs/trans/preorder”
     */
    String getApiSubURI();

    /**
     * 获取api版本
     *
     * @return
     */
    String getVersion();

    /**
     * 获取requestClass
     *
     * @return
     */
    <T extends FuiouBizRequest>  Class<T> getRequestClass();

    /**
     * 获取responseClass
     *
     * @return
     */
    <T extends FuiouBizResponse> Class<T> getResponseClass();
}