package com.fshows.fuiou.client.bank;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.fshows.fuiou.exception.FuiouApiException;
import com.fshows.fuiou.request.bank.AddMchntActiveSdkRequest;
import com.fshows.fuiou.request.bank.BankActivitySdkRequest;
import com.fshows.fuiou.request.bank.OpenCardSdkRequest;
import com.fshows.fuiou.request.bank.QueryActiveSdkRequest;
import com.fshows.fuiou.request.bank.QueryCardSdkRequest;
import com.fshows.fuiou.request.bank.QueryMchntActiveSdkRequest;
import com.fshows.fuiou.request.bank.QueryReliefCfgSdkRequest;
import com.fshows.fuiou.request.bank.QueryReliefRemainSdkRequest;
import com.fshows.fuiou.response.bank.AddMchntActiveSdkResponse;
import com.fshows.fuiou.response.bank.BankActivitySdkResponse;
import com.fshows.fuiou.response.bank.OpenCardSdkResponse;
import com.fshows.fuiou.response.bank.QueryActiveSdkResponse;
import com.fshows.fuiou.response.bank.QueryCardSdkResponse;
import com.fshows.fuiou.response.bank.QueryMchntActiveSdkResponse;
import com.fshows.fuiou.response.bank.QueryReliefCfgSdkResponse;
import com.fshows.fuiou.response.bank.QueryReliefRemainSdkResponse;
import com.fshows.fuiou.util.LogUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.reflect.FieldUtils;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.LinkedList;

@Slf4j
@RequiredArgsConstructor
public class BankActivityHttpClient {

    private final static String SUCCESS_CODE = "0000";
    //合作方支持申请活动列表查询
    private final static String queryActive = "/mchntActiveOut.fuiou?action=queryActive";
    //商户银行活动报名申请
    private final static String addMchntActive = "/mchntActiveOut.fuiou?action=addMchntActive";
    //商户开卡申请接口
    private final static String openCard = "/mchntActiveOut.fuiou?action=openCard";
    //商户开卡申请结果查询
    private final static String queryCardResult = "/mchntActiveOut.fuiou?action=queryCardResult";
    //商户报名申请结果查询
    private final static String queryMchntActiveResult = "/mchntActiveOut.fuiou?action=queryMchntActiveResult";
    //合作方减免配置查询
    private final static String queryReliefCfg = "/mchntFeeReliefOut.fuiou?action=queryReliefCfg";
    //合作方减免剩余额度查询
    private final static String queryReliefRemain = "/mchntFeeReliefOut.fuiou?action=queryReliefRemain";
    private final BankActivityClientConfig bankActivityClientConfig;

    public <Request extends BankActivitySdkRequest, Response extends BankActivitySdkResponse>
    Response post(String url, Request request, Class<Response> responseClass) throws FuiouApiException {

        url = bankActivityClientConfig.getHost() + url;

        request.setRelateInsCd(bankActivityClientConfig.getRelateInsCd());
        request.setSign(getSign(request));

        String requestBody = JSONObject.toJSONString(request);
        LogUtil.info(log, "富友活动 >> requestBody={}", requestBody);

        String responseBody = HttpUtil.post(url, requestBody, 4000);
        LogUtil.info(log, "富友活动 >> response={}", responseBody);

        Response response = JSONObject.parseObject(responseBody, responseClass);

        if (SUCCESS_CODE.equals(response.getResponseCode())) {
            return response;
        }

        throw new FuiouApiException(response.getResponseDesc());
    }

    public QueryActiveSdkResponse queryActive(QueryActiveSdkRequest request) throws FuiouApiException {
        return post(queryActive, request, QueryActiveSdkResponse.class);
    }

    public AddMchntActiveSdkResponse addMchntActive(AddMchntActiveSdkRequest request) throws FuiouApiException {
        return post(addMchntActive, request, AddMchntActiveSdkResponse.class);
    }

    public OpenCardSdkResponse openCard(OpenCardSdkRequest request) throws FuiouApiException {
        return post(openCard, request, OpenCardSdkResponse.class);
    }

    public QueryCardSdkResponse queryCardResult(QueryCardSdkRequest request) throws FuiouApiException {
        return post(queryCardResult, request, QueryCardSdkResponse.class);
    }

    public QueryMchntActiveSdkResponse queryMchntActiveResult(QueryMchntActiveSdkRequest request) throws FuiouApiException {
        return post(queryMchntActiveResult, request, QueryMchntActiveSdkResponse.class);
    }

    public QueryReliefCfgSdkResponse queryReliefCfg(QueryReliefCfgSdkRequest request) throws FuiouApiException {
        return post(queryReliefCfg, request, QueryReliefCfgSdkResponse.class);
    }

    public QueryReliefRemainSdkResponse queryReliefRemain(QueryReliefRemainSdkRequest request) throws FuiouApiException {
        return post(queryReliefRemain, request, QueryReliefRemainSdkResponse.class);
    }


    private <Request> String getSign(Request request) {
        try {
            Field[] declaredFields = FieldUtils.getAllFields(request.getClass());

            LinkedList<String> list = new LinkedList<>();

            for (Field declaredField : declaredFields) {
                declaredField.setAccessible(true);
                Object value = declaredField.get(request);
                if (value == null || "mchntCd".equalsIgnoreCase(declaredField.getName())) {
                    continue;
                }
                list.add(declaredField.getName().toLowerCase() + "=" + value);
            }

            Collections.sort(list);

            list.add("key=" + bankActivityClientConfig.getSignKey());

            String str = String.join("&", list);

            return DigestUtils.md5Hex(str.getBytes("GBK"));
        } catch (Exception e) {
            throw new RuntimeException(new FuiouApiException("富友银行活动接口前签名异常"));
        }
    }
}
