/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.steward.component;

import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.URLUtil;
import cn.hutool.core.util.XmlUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fshows.fuiou.response.settlement.FuiouQuerySettlementResponse;
import com.fshows.fuiou.util.FuiouRequestUtils;
import com.fshows.fuiou.util.LogUtil;
import com.fshows.fuiou.util.RsaUtils;
import com.fshows.fuiou.util.XmlConvertUtil;
import com.fshows.sdk.core.client.base.definition.IResponseDefinition;
import com.fshows.sdk.core.client.base.handler.ISerializableHandler;
import com.fshows.sdk.core.client.base.model.ApiRequestModel;
import com.fshows.sdk.core.client.base.model.ApiResponseModel;
import com.fshows.sdk.core.client.base.model.DefaultClientConfigModel;
import com.fshows.sdk.core.client.base.model.DefaultRequestContext;
import com.fshows.sdk.core.exception.FsApiException;
import com.fshows.steward.apienum.FuStewardApiDefinitionEnum;
import com.fshows.steward.enums.FuStewardApiTypeEnum;
import com.fshows.steward.request.FuStewardBaseRequest;
import com.fshows.steward.response.FuStewardBaseResponse;
import com.fshows.steward.response.FuStewardBizResponse;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FuStewardSerializableHandler
implements ISerializableHandler {
    private static final Logger log = LoggerFactory.getLogger(FuStewardSerializableHandler.class);

    public String serializeObject(ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) {
        if (!(requestContext.getIApiDefinition() instanceof FuStewardApiDefinitionEnum)) {
            throw new FsApiException("\u53c2\u6570\u5e8f\u5217\u5316\u5931\u8d25");
        }
        FuStewardApiDefinitionEnum apiDefinitionEnum = (FuStewardApiDefinitionEnum)requestContext.getIApiDefinition();
        if (FuStewardApiTypeEnum.ENCRYPT_API.equals((Object)apiDefinitionEnum.getApiTypeEnum())) {
            return this.encryptApiSerializeObject(apiRequestModel, requestContext);
        }
        return this.normalApiSerializeObject(apiRequestModel, requestContext);
    }

    private String normalApiSerializeObject(ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) {
        String xmlStr = FuiouRequestUtils.generateXmlByObjectMap(apiRequestModel.getParamMap());
        String enCodeStr = URLUtil.encodeAll((String)xmlStr, (Charset)CharsetUtil.CHARSET_GBK);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("req", enCodeStr);
        apiRequestModel.setRequestForm(params);
        return enCodeStr;
    }

    private String encryptApiSerializeObject(ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) {
        FuStewardBaseRequest request = (FuStewardBaseRequest)apiRequestModel.getRequest();
        DefaultClientConfigModel apiClientConfig = requestContext.getApiClientConfig();
        String xmlStr = FuiouRequestUtils.generateXmlByObjectMap(apiRequestModel.getParamMap());
        String encrypt = RsaUtils.encrypt(xmlStr, apiClientConfig.getPayCompanyPublicKey());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("mchntCd", request.getMchntCd());
        params.put("message", encrypt);
        return JSON.toJSONString(params);
    }

    public IResponseDefinition deserializationResponse(ApiResponseModel apiResponseModel, ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) {
        if (!(requestContext.getIApiDefinition() instanceof FuStewardApiDefinitionEnum)) {
            throw new FsApiException("\u53c2\u6570\u5e8f\u5217\u5316\u5931\u8d25");
        }
        FuStewardApiDefinitionEnum apiDefinitionEnum = (FuStewardApiDefinitionEnum)requestContext.getIApiDefinition();
        if (FuStewardApiTypeEnum.ENCRYPT_API.equals((Object)apiDefinitionEnum.getApiTypeEnum())) {
            return this.encryptApiDeserializationResponse(apiResponseModel, apiRequestModel, requestContext);
        }
        return this.normalApiDeserializationResponse(apiResponseModel, apiRequestModel, requestContext);
    }

    private IResponseDefinition normalApiDeserializationResponse(ApiResponseModel apiResponseModel, ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) {
        try {
            FuStewardBaseResponse baseResponse = new FuStewardBaseResponse();
            String deCodeStr = URLUtil.decode((String)apiResponseModel.getResponseBody(), (String)"GBK");
            FuStewardBizResponse bizResponse = (FuStewardBizResponse)XmlConvertUtil.xml2Bean(deCodeStr, requestContext.getIApiDefinition().getResponseClass());
            baseResponse.setData(bizResponse);
            baseResponse.setMchntCd(bizResponse.getMchntCd());
            apiResponseModel.setResponseSign(bizResponse.getSignature());
            apiResponseModel.setResponseMap(FuiouRequestUtils.ObjectToMap(bizResponse));
            return baseResponse;
        }
        catch (Exception e) {
            LogUtil.error(log, "\u3010fuiou-sdk-fusteward\u3011\u54cd\u5e94\u7ed3\u679c\u53cd\u5e8f\u5217\u5316\u5f02\u5e38 >> resBody={}", e, apiResponseModel.getResponseBody());
            throw new FsApiException("[fuiou-sdk-fusteward]\u54cd\u5e94\u7ed3\u679c\u53cd\u5e8f\u5217\u5316\u5f02\u5e38");
        }
    }

    public static void main(String[] args) {
        String xml = "<xml><count>1</count><ins_cd>08M0031681</ins_cd><mchnt_cd>0003310F6813298</mchnt_cd><random_str>4ZSSIW7I5QPZZ5F69XVJPCKVHWDYLUIU</random_str><result_code>000000</result_code><result_msg>SUCCESS</result_msg><sign>Z9Y4NlhB2EG2quzJPY2uBoGHl5V1uswOmR4BD0byUJUWRuVocr/Z+Kh79VkQTsoeigMs9xv472ds6IJp6iPTuHqni/V8Vhck0tiNspBO3xuCy4T+Ov/E/WqQfZtPAteJtwjb8dJLLXUFv0B1QmaP20WcXEI1Z0QJQt7B5FnTsFw=</sign><txnList><txn><acnt_nm>\u738b\u9752</acnt_nm><acnt_no>623091***4142</acnt_no><dest_txn_amt>149</dest_txn_amt><iss_bank_nm>\u4e2d\u56fd\u90ae\u653f\u50a8\u84c4\u94f6\u884c\u603b\u884c</iss_bank_nm><kbps_src_settle_dt>20240118</kbps_src_settle_dt><kbps_trace_no>181100857374</kbps_trace_no><not_settle_amt>0</not_settle_amt><out_order_no>20240118110029512320FUS</out_order_no><pay_msg></pay_msg><pay_st>1</pay_st><pay_st_desc>\u6210\u529f</pay_st_desc><src_mchnt_cd>0003310F6813298</src_mchnt_cd><txn_fee_amt>0</txn_fee_amt><txn_rcv_ts>20240118110030</txn_rcv_ts></txn></txnList></xml>";
        Map resMap = XmlUtil.xmlToMap((String)xml);
        System.out.println(JSONObject.toJSONString((Object)resMap, (boolean)true));
        System.out.println(JSONObject.parseObject((String)JSONObject.toJSONString((Object)resMap), FuiouQuerySettlementResponse.class));
        try {
            FuiouQuerySettlementResponse response = XmlConvertUtil.xml2Bean(xml, FuiouQuerySettlementResponse.class);
            System.out.println(response);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private IResponseDefinition encryptApiDeserializationResponse(ApiResponseModel apiResponseModel, ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) {
        FuStewardBaseResponse baseResponse = new FuStewardBaseResponse();
        DefaultClientConfigModel configModel = requestContext.getApiClientConfig();
        Map resMap = null;
        try {
            resMap = XmlUtil.xmlToMap((String)apiResponseModel.getResponseBody());
        }
        catch (Exception e) {
            LogUtil.error(log, "\u3010fuiou-sdk-fusteward\u3011\u54cd\u5e94\u7ed3\u679c\u53cd\u5e8f\u5217\u5316\u5f02\u5e38 >> resBody={}", e, apiResponseModel.getResponseBody());
            throw new FsApiException("[fuiou-sdk-fusteward]\u54cd\u5e94\u7ed3\u679c\u53cd\u5e8f\u5217\u5316\u5f02\u5e38");
        }
        String mchntCd = resMap.get("mchntCd").toString();
        baseResponse.setMchntCd(mchntCd);
        String message = resMap.get("message").toString();
        String encrypt = RsaUtils.decrypt(message, configModel.getFubeiPrivateKey());
        Map<String, String> bizMap = null;
        try {
            bizMap = FuiouRequestUtils.getMapFromXML(encrypt);
        }
        catch (Exception e) {
            LogUtil.error(log, "\u3010fuiou-sdk-fusteward\u3011\u54cd\u5e94\u7ed3\u679c\u53cd\u5e8f\u5217\u5316\u5f02\u5e38 >> resBody={}", e, encrypt);
            throw new FsApiException("[fuiou-sdk-fusteward]\u54cd\u5e94\u7ed3\u679c\u53cd\u5e8f\u5217\u5316\u5f02\u5e38");
        }
        FuStewardBizResponse bizResponse = (FuStewardBizResponse)FuiouRequestUtils.mapToObject(resMap, requestContext.getIApiDefinition().getResponseClass());
        String signature = bizMap.remove("signature");
        apiResponseModel.setResponseSign(signature);
        baseResponse.setData(bizResponse);
        return baseResponse;
    }
}

