/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fuiou.util;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ReflectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.fshows.fuiou.util.LogUtil;
import com.fshows.sdk.core.exception.FsApiException;
import com.fshows.steward.annotation.NoSign;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FuiouRequestUtils {
    private static final Logger log = LoggerFactory.getLogger(FuiouRequestUtils.class);
    private static final Map<Class, Field[]> CACHE_FIELD_MAP = new ConcurrentHashMap<Class, Field[]>();
    private static final String XML = "xml";
    private static final String DEFAULT_CHARSET = "GBK";
    private static final String EMPTY = "";
    private static final String BENE_INFOS = "bene_infos";
    private static final String BENE_INFO = "bene";
    private static final String[] IGNORE_FIELD_ARR = new String[]{"serialVersionUID"};
    private static Pattern UNDERLINE_PATTERN = Pattern.compile("[A-Z]");

    public static InputStream getStringStream(String sInputString) throws UnsupportedEncodingException {
        ByteArrayInputStream tInputStringStream = null;
        if (sInputString != null && !sInputString.trim().equals(EMPTY)) {
            tInputStringStream = new ByteArrayInputStream(sInputString.getBytes(DEFAULT_CHARSET));
        }
        return tInputStringStream;
    }

    public static <Res> Res getObjectFromXML(String xml, Class<Res> tClass) throws Exception {
        Map<String, String> mapFromXML = FuiouRequestUtils.getMapFromXML(xml);
        return (Res)BeanUtil.toBean(mapFromXML, tClass);
    }

    public static <Res> Res getObjectFromMap(Map<String, String> mapFromXML, Class<Res> tClass) {
        return (Res)BeanUtil.toBean(mapFromXML, tClass);
    }

    public static Map<String, String> toMap(Object obj) {
        Field[] fields = CACHE_FIELD_MAP.get(obj.getClass());
        if (fields == null) {
            fields = ReflectUtil.getFields(obj.getClass());
            CACHE_FIELD_MAP.put(obj.getClass(), fields);
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (Field field : fields) {
            try {
                field.setAccessible(true);
                if (Modifier.isStatic(field.getModifiers()) || ArrayUtil.contains((Object[])IGNORE_FIELD_ARR, (Object)field.getName())) continue;
                String key = field.getName();
                Object val = field.get(obj);
                if (val != null) {
                    map.put(FuiouRequestUtils.camelToUnderline(key), FuiouRequestUtils.dealSpecialCharacter(String.valueOf(val)));
                    continue;
                }
                map.put(FuiouRequestUtils.camelToUnderline(key), null);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return map;
    }

    private static String dealSpecialCharacter(String str) {
        return str.replaceAll("&", EMPTY).replaceAll("<", EMPTY).replaceAll(">", EMPTY);
    }

    public static Map<String, String> toMap(Object obj, boolean isHump) {
        Field[] fields = CACHE_FIELD_MAP.get(obj.getClass());
        if (fields == null) {
            fields = ReflectUtil.getFields(obj.getClass());
            CACHE_FIELD_MAP.put(obj.getClass(), fields);
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (Field field : fields) {
            try {
                field.setAccessible(true);
                if (Modifier.isStatic(field.getModifiers()) || ArrayUtil.contains((Object[])IGNORE_FIELD_ARR, (Object)field.getName())) continue;
                String key = field.getName();
                Object val = field.get(obj);
                if (val == null) continue;
                map.put(isHump ? key : FuiouRequestUtils.camelToUnderline(key), FuiouRequestUtils.dealSpecialCharacter(String.valueOf(val)));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return map;
    }

    public static String calcExpireTime(Date now, String expireInMinutes, SimpleDateFormat dateFormat) {
        return dateFormat.format(now.getTime() + Long.parseLong(expireInMinutes) * 60L * 1000L);
    }

    public static String camelToUnderline(String str) {
        Matcher matcher = UNDERLINE_PATTERN.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static Map<String, String> getMapFromXML(String xmlString) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        InputStream is = FuiouRequestUtils.getStringStream(xmlString);
        Document document = builder.parse(is);
        NodeList allNodes = document.getFirstChild().getChildNodes();
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (int i = 0; i < allNodes.getLength(); ++i) {
            Node node = allNodes.item(i);
            if (!(node instanceof Element)) continue;
            map.put(node.getNodeName(), node.getTextContent());
        }
        return map;
    }

    public static Map<String, String> xmlStringToMap(String xmlString) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(xmlString.getBytes());
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(inputStream);
            Element root = document.getDocumentElement();
            NodeList nodeList = root.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                String nodeName = node.getNodeName();
                String nodeValue = node.getTextContent().trim();
                resultMap.put(nodeName, nodeValue);
            }
        }
        catch (Exception e) {
            LogUtil.error(log, "\u3010fuiou-sdk-fusteward\u3011 xml\u6587\u4ef6\u89e3\u6790\u5f02\u5e38 ,xmlStr:{}", xmlString);
            throw new FsApiException("\u3010fuiou-sdk-fusteward\u3011xml\u6587\u4ef6\u89e3\u6790\u5f02\u5e38");
        }
        return resultMap;
    }

    public static <Res> Res mapToObject(Map<String, Object> mapFromXML, Class<Res> tClass) {
        String jsonStr = JSON.toJSONString(mapFromXML);
        return (Res)JSON.parseObject((String)jsonStr, tClass);
    }

    public static String generateXml(Map<String, String> data) {
        StringBuilder xmlBuilder = new StringBuilder();
        xmlBuilder.append("<?xml version=\"1.0\" encoding=\"GBK\" standalone=\"yes\"?>");
        xmlBuilder.append("<xml>");
        for (Map.Entry<String, String> entry : data.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (value == null) continue;
            xmlBuilder.append("<").append(key).append(">").append(value).append("</").append(key).append(">");
        }
        xmlBuilder.append("</xml>");
        return xmlBuilder.toString();
    }

    public static String generateXmlByObjectMap(Map<String, Object> data) {
        StringBuilder xmlBuilder = new StringBuilder();
        xmlBuilder.append("<xml>");
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof List) {
                FuiouRequestUtils.handleListValue(xmlBuilder, key, (List)value);
                continue;
            }
            FuiouRequestUtils.handleScalarValue(xmlBuilder, key, value);
        }
        xmlBuilder.append("</xml>");
        return xmlBuilder.toString();
    }

    private static void handleScalarValue(StringBuilder xmlBuilder, String key, Object value) {
        if (value != null && !value.toString().isEmpty()) {
            xmlBuilder.append("<").append(key).append(">").append(value).append("</").append(key).append(">");
        } else {
            xmlBuilder.append("<").append(key).append("/>");
        }
    }

    private static void handleListValue(StringBuilder xmlBuilder, String key, List<?> list) {
        xmlBuilder.append("<").append(key).append(">");
        for (Object listItem : list) {
            if (key.equalsIgnoreCase(BENE_INFOS)) {
                xmlBuilder.append("<").append(BENE_INFO).append(">");
            } else {
                xmlBuilder.append("<").append(key).append(">");
            }
            if (listItem instanceof String || listItem instanceof Integer || listItem instanceof Long || listItem instanceof Double || listItem instanceof BigDecimal || listItem instanceof Float) {
                xmlBuilder.append(listItem);
            } else {
                Map map = (Map)listItem;
                TreeMap treeMap = new TreeMap(map);
                for (Map.Entry entry : treeMap.entrySet()) {
                    String itemKey = (String)entry.getKey();
                    Object itemValue = entry.getValue();
                    if (itemValue != null && !itemValue.toString().isEmpty()) {
                        xmlBuilder.append("<").append(itemKey).append(">").append(itemValue).append("</").append(itemKey).append(">");
                        continue;
                    }
                    xmlBuilder.append("<").append(itemKey).append("/>");
                }
            }
            if (key.equalsIgnoreCase(BENE_INFOS)) {
                xmlBuilder.append("</").append(BENE_INFO).append(">");
                continue;
            }
            xmlBuilder.append("</").append(key).append(">");
        }
        xmlBuilder.append("</").append(key).append(">");
    }

    public static Map<String, Object> ObjectToMap(Object object) {
        String jsonString = JSON.toJSONString((Object)object, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        Map resultMap = (Map)JSON.parseObject((String)jsonString, (TypeReference)new TypeReference<TreeMap<String, Object>>(){}, (Feature[])new Feature[0]);
        return resultMap;
    }

    public static Map<String, Object> ObjectToMapFgj(Object object) {
        String jsonString = JSON.toJSONString((Object)object, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        if (jsonString.contains("insCd")) {
            jsonString = jsonString.replace("insCd", "ins_cd");
        }
        Map resultMap = (Map)JSON.parseObject((String)jsonString, (TypeReference)new TypeReference<TreeMap<String, Object>>(){}, (Feature[])new Feature[0]);
        return resultMap;
    }

    public static String[] getNoNeedSign(Class<?> clazz) {
        ArrayList<String> noSignFields = new ArrayList<String>();
        FuiouRequestUtils.processFields(clazz, noSignFields);
        return noSignFields.toArray(new String[0]);
    }

    private static void processFields(Class<?> clazz, List<String> noSignFields) {
        List<Field> allFields = FuiouRequestUtils.getAllFields(clazz);
        for (Field field : allFields) {
            Class<?> genericType;
            if (field.isAnnotationPresent(NoSign.class)) {
                noSignFields.add(field.getName());
            }
            if (!List.class.isAssignableFrom(field.getType()) || (genericType = FuiouRequestUtils.getGenericType(field)) == null) continue;
            FuiouRequestUtils.processFields(genericType, noSignFields);
        }
    }

    private static List<Field> getAllFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (clazz != null) {
            for (Field field : clazz.getDeclaredFields()) {
                fields.add(field);
            }
            clazz = clazz.getSuperclass();
        }
        return fields;
    }

    private static Class<?> getGenericType(Field field) {
        ParameterizedType paramType;
        Type[] actualTypes;
        Type genericType = field.getGenericType();
        if (genericType instanceof ParameterizedType && (actualTypes = (paramType = (ParameterizedType)genericType).getActualTypeArguments()).length > 0 && actualTypes[0] instanceof Class) {
            return (Class)actualTypes[0];
        }
        return null;
    }

    public static void main(String[] args) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("ins_cd", "08A9999999");
        data.put("mchnt_cd", "0002900F0370542");
        data.put("term_id", "12345678");
        data.put("random_str", "d0194c1024f180065d2434fa8b6a2f82");
        data.put("txn_begin_ts", "20201201151802");
        data.put("order_type", "WECHAT");
        String xml = FuiouRequestUtils.generateXml(data);
        System.out.println(xml);
    }
}

