/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fuiou.client.bank;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.fshows.fuiou.client.bank.BankActivityClientConfig;
import com.fshows.fuiou.exception.FuiouApiException;
import com.fshows.fuiou.request.bank.AddMchntActiveSdkRequest;
import com.fshows.fuiou.request.bank.BankActivitySdkRequest;
import com.fshows.fuiou.request.bank.OpenCardSdkRequest;
import com.fshows.fuiou.request.bank.QueryActiveSdkRequest;
import com.fshows.fuiou.request.bank.QueryCardSdkRequest;
import com.fshows.fuiou.request.bank.QueryMchntActiveSdkRequest;
import com.fshows.fuiou.request.bank.QueryReliefCfgSdkRequest;
import com.fshows.fuiou.request.bank.QueryReliefRemainSdkRequest;
import com.fshows.fuiou.response.bank.AddMchntActiveSdkResponse;
import com.fshows.fuiou.response.bank.BankActivitySdkResponse;
import com.fshows.fuiou.response.bank.OpenCardSdkResponse;
import com.fshows.fuiou.response.bank.QueryActiveSdkResponse;
import com.fshows.fuiou.response.bank.QueryCardSdkResponse;
import com.fshows.fuiou.response.bank.QueryMchntActiveSdkResponse;
import com.fshows.fuiou.response.bank.QueryReliefCfgSdkResponse;
import com.fshows.fuiou.response.bank.QueryReliefRemainSdkResponse;
import com.fshows.fuiou.util.LogUtil;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.LinkedList;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BankActivityHttpClient {
    private static final Logger log = LoggerFactory.getLogger(BankActivityHttpClient.class);
    private static final String SUCCESS_CODE = "0000";
    private static final String queryActive = "/mchntActiveOut.fuiou?action=queryActive";
    private static final String addMchntActive = "/mchntActiveOut.fuiou?action=addMchntActive";
    private static final String openCard = "/mchntActiveOut.fuiou?action=openCard";
    private static final String queryCardResult = "/mchntActiveOut.fuiou?action=queryCardResult";
    private static final String queryMchntActiveResult = "/mchntActiveOut.fuiou?action=queryMchntActiveResult";
    private static final String queryReliefCfg = "/mchntFeeReliefOut.fuiou?action=queryReliefCfg";
    private static final String queryReliefRemain = "/mchntFeeReliefOut.fuiou?action=queryReliefRemain";
    private final BankActivityClientConfig bankActivityClientConfig;

    public <Request extends BankActivitySdkRequest, Response extends BankActivitySdkResponse> Response post(String url, Request request, Class<Response> responseClass) throws FuiouApiException {
        url = this.bankActivityClientConfig.getHost() + url;
        request.setRelateInsCd(this.bankActivityClientConfig.getRelateInsCd());
        request.setSign(this.getSign(request));
        String requestBody = JSONObject.toJSONString(request);
        LogUtil.info(log, "\u5bcc\u53cb\u6d3b\u52a8 >> requestBody={}", requestBody);
        String responseBody = HttpUtil.post((String)url, (String)requestBody, (int)4000);
        LogUtil.info(log, "\u5bcc\u53cb\u6d3b\u52a8 >> response={}", responseBody);
        BankActivitySdkResponse response = (BankActivitySdkResponse)JSONObject.parseObject((String)responseBody, responseClass);
        if (SUCCESS_CODE.equals(response.getResponseCode())) {
            return (Response)response;
        }
        throw new FuiouApiException(response.getResponseDesc());
    }

    public QueryActiveSdkResponse queryActive(QueryActiveSdkRequest request) throws FuiouApiException {
        return this.post(queryActive, request, QueryActiveSdkResponse.class);
    }

    public AddMchntActiveSdkResponse addMchntActive(AddMchntActiveSdkRequest request) throws FuiouApiException {
        return this.post(addMchntActive, request, AddMchntActiveSdkResponse.class);
    }

    public OpenCardSdkResponse openCard(OpenCardSdkRequest request) throws FuiouApiException {
        return this.post(openCard, request, OpenCardSdkResponse.class);
    }

    public QueryCardSdkResponse queryCardResult(QueryCardSdkRequest request) throws FuiouApiException {
        return this.post(queryCardResult, request, QueryCardSdkResponse.class);
    }

    public QueryMchntActiveSdkResponse queryMchntActiveResult(QueryMchntActiveSdkRequest request) throws FuiouApiException {
        return this.post(queryMchntActiveResult, request, QueryMchntActiveSdkResponse.class);
    }

    public QueryReliefCfgSdkResponse queryReliefCfg(QueryReliefCfgSdkRequest request) throws FuiouApiException {
        return this.post(queryReliefCfg, request, QueryReliefCfgSdkResponse.class);
    }

    public QueryReliefRemainSdkResponse queryReliefRemain(QueryReliefRemainSdkRequest request) throws FuiouApiException {
        return this.post(queryReliefRemain, request, QueryReliefRemainSdkResponse.class);
    }

    private <Request> String getSign(Request request) {
        try {
            Field[] declaredFields = FieldUtils.getAllFields(request.getClass());
            LinkedList<String> list = new LinkedList<String>();
            for (Field declaredField : declaredFields) {
                declaredField.setAccessible(true);
                Object value = declaredField.get(request);
                if (value == null || "mchntCd".equalsIgnoreCase(declaredField.getName())) continue;
                list.add(declaredField.getName().toLowerCase() + "=" + value);
            }
            Collections.sort(list);
            list.add("key=" + this.bankActivityClientConfig.getSignKey());
            String str = String.join((CharSequence)"&", list);
            return DigestUtils.md5Hex((byte[])str.getBytes("GBK"));
        }
        catch (Exception e) {
            throw new RuntimeException(new FuiouApiException("\u5bcc\u53cb\u94f6\u884c\u6d3b\u52a8\u63a5\u53e3\u524d\u7b7e\u540d\u5f02\u5e38"));
        }
    }

    public BankActivityHttpClient(BankActivityClientConfig bankActivityClientConfig) {
        this.bankActivityClientConfig = bankActivityClientConfig;
    }
}

