/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.steward.response.trade;


import com.fshows.steward.response.FuStewardBizResponse;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 转账记账退回接口
 *
 * @author
 * @version FuStdAccountInTransferToMchntRefundRes.java, v 0.1 2024-01-02 15:52:40
 */
@Data
public class FuStdAccountInTransferToMchntRefundRes extends FuStewardBizResponse {

    private static final long serialVersionUID = -2213838555462704382L;


    /**
     * 商户流水号
     * 唯一流水号，商户定义
     * (必填)
     */
    @NotBlank
    private String traceNo;

    /**
     * 用户编号
     * 
     * (必填)
     */
    @NotBlank
    private String accountIn;

    /**
     * 源交易富友批次号
     * 
     * (必填)
     */
    @NotBlank
    private String batchNo;

    /**
     * 退回金额
     * 
     * (必填)
     */
    @NotNull
    private String amt;

}