/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.steward.response.query.account;

import lombok.Data;

/**
 * @author wangqilei
 * @version FuStdQueryAllocateAccountInDetail.java, v 0.1 2024-03-21 4:21 PM wangqilei
 */
@Data
public class FuStdQueryAllocateAccountInDetail {
    /**
     * 用户开户请求流水号
     * (必填)
     */
    private String mchntTraceNo;

    /**
     * 用户编号
     * (必填)
     */
    private String accountIn;

    /**
     * 开户银行行号
     * (选填)
     */
    private String interBankNo;

    /**
     * 开户银行名称
     * (必填)
     */
    private String outAcntNm;

    /**
     * 手机号码
     * (必填)
     */
    private String mobile;

    /**
     * 证件号
     * (必填)
     */
    private String licNo;

    /**
     * 分账比例
     * (必填)
     */
    private Integer allocateScale;

    /**
     * 状态
     * 00 协议未签署
     * 01 失效（24 小时失效或
     * 者 3 次签约失效）
     * 02 生效
     * 03 禁用
     * 05 冻结
     * 06 待银行开户
     * (必填)
     */
    private String status;

    /**
     * 银行收款账户号
     * (选填)
     */
    private String bankAcctNo;

    /**
     * 银行账户联行号
     * (选填)
     */
    private String bankInterNo;

    /**
     * 开户银行名称
     * (选填)
     */
    private String bankNm;

    /**
     * 富友收款记账户账号
     * (选填)
     */
    private String depositAccount;

    /**
     * 开户行名称
     * (选填)
     */
    private String issInsName;

    /**
     * 开户省市区
     * (选填)
     */
    private String issCityName;

    /**
     * 支行名称
     * (选填)
     */
    private String subBranchName;

    /**
     * 开户行行号
     * (选填)
     */
    private String fyInterBankNo;
}