/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.steward.request.query;

import com.fshows.steward.request.FuStewardBizRequest;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author wangqilei
 * @version FuiouElectronicVoucherQueryRequest.java, v 0.1 2024-03-21 11:19 AM wangqilei
 */
@Data
public class FuStdQueryElectronicVoucherReq extends FuStewardBizRequest {
    private static final long serialVersionUID = 6282993327995168535L;
    /**
     * 唯一流水号，商户定义，参与签名
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "traceNo长度不能超过30")
    private String traceNo;

    /**
     * 接入商户在富友的唯一代码，参与签名
     * (必填)
     */
    @NotBlank
    @Length(max = 40, message = "mchntCd长度不能超过40")
    private String mchntCd;

    /**
     * 01 分账, 02 用户间转账, 03 委托结算, 04 商户结算, 05 转账记账, 06 充值记账
     * (必填)
     */
    @NotNull
    private String busiType;

    /**
     * 只传交易批次号时必填，部分业务类型返回批量交易凭证
     * (选填)
     */
    private String srcBatchNo;

    /**
     * 传入交易参考号时必填，返回单笔交易凭证
     * (选填)
     */
    private String srcFasSsn;
}