/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.steward.request.query;

import com.fshows.steward.request.FuStewardBizRequest;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * @author wangqilei
 * @version FuStdQueryAllocateAccountReq.java, v 0.1 2024-03-21 4:03 PM wangqilei
 */
@Data
public class FuStdQueryAllocateAccountReq extends FuStewardBizRequest {
    private static final long serialVersionUID = -8306515832872123982L;
    /**
     * 接入商户在富友的唯一代码
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "mchntCd长度不能超过30")
    private String mchntCd;

    /**
     * 创建用户时提交的开户请求流水号
     * (选填)
     */
    @Length(max = 30, message = "mchntTraceNo长度不能超过30")
    private String mchntTraceNo;

    /**
     * 创建用户时提交的开户名称
     * (选填)
     */
    @Length(max = 128, message = "outAcntNm长度不能超过128")
    private String outAcntNm;

    /**
     * 创建用户时提交的手机号
     * (选填)
     */
    @Length(max = 20, message = "mobile长度不能超过20")
    private String mobile;

    /**
     * 开户银行账号
     * (选填)
     */
    @Length(max = 40, message = "outAcntNo长度不能超过40")
    private String outAcntNo;

    /**
     * 用户编号
     * (选填)
     */
    @Length(max = 30, message = "accountIn长度不能超过30")
    private String accountIn;

    /**
     * 个人身份证号码
     * (选填)
     */
    @Length(max = 20, message = "idNo长度不能超过20")
    private String idNo;
}