/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.steward.request.account;

import com.fshows.sdk.core.client.base.definition.IRequestDefinition;
import lombok.Data;
import org.hibernate.validator.constraints.Length;
import com.fshows.steward.request.FuStewardBizRequest;
import javax.validation.constraints.NotNull;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 用户创建接口
 *
 * @author
 * @version FuStdCustomerCreateReq.java, v 0.1 2024-01-02 10:33:53
 */
@Data
public class FuStdCustomerCreateReq extends FuStewardBizRequest {

    private static final long serialVersionUID = -2213838555563341901L;


    /**
     * 商户流水号
     * 唯一流水号，商户定义
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "traceNo长度不能超过30")
    private String traceNo;

    /**
     * 账户类型
     * 01 个人， 02 企业
     * (必填)
     */
    @NotBlank
    @Length(max = 4, message = "cleanType长度不能超过4")
    private String cleanType;

    /**
     * 户名
     * 户名
     * (必填)
     */
    @NotBlank
    private String outAcntNm;

    /**
     * 证件类型
     * 个人： 0 身份证；1 其他 企业： 1 营业执照
     * (必填)
     */
    @NotBlank
    @Length(max = 2, message = "certTp长度不能超过2")
    private String certTp;

    /**
     * 证件号码
     * 企业：社会信用代码 个人：身份证号码
     * (必填)
     */
    @NotBlank
    @Length(max = 40, message = "certNo长度不能超过40")
    private String certNo;

    /**
     * 银行账户开户行
     * 01 百信、 02 华通、 06 平安、 04 众 邦、 05 厦门国际
     * (选填)
     */
    @Length(max = 2, message = "channel长度不能超过2")
    private String channel;

    /**
     * 主体类型
     * 企业子户同步开通银行账户必填 1-企业商户 2-个体工商户 3-政府机关事业单位 4-其他组织
     * (选填)
     */
    @Length(max = 4, message = "organizationType长度不能超过4")
    private String organizationType;

    /**
     * 基本账户开户许可 核准号
     * 企业子户同步开通银行账户必填 channel=04 时，必填
     * (选填)
     */
    @Length(max = 20, message = "bcpNo长度不能超过20")
    private String bcpNo;

    /**
     * 营业执照有效期起始时间
     * 企业子户同步开通银行账户必填
     * (选填)
     */
    @Length(max = 10, message = "busiLicValidateStart长度不能超过10")
    private String busiLicValidateStart;

    /**
     * 营业执照有效期结束时间
     * 企业子户同步开通银行账户必填
     * (选填)
     */
    @Length(max = 10, message = "busiLicValidateEnd长度不能超过10")
    private String busiLicValidateEnd;

    /**
     * 营业执照注册地址
     * 企业子户同步开通银行账户必填
     * (选填)
     */
    @Length(max = 128, message = "busiLicAddr长度不能超过128")
    private String busiLicAddr;

    /**
     * 营业执照照片
     * 企业子户同步开通银行账户必填 channel=04/06 时，必填
     * (选填)
     */
    private String busiLicPic;

    /**
     * 法人姓名
     * 企业子户同步开通银行账户必填
     * (选填)
     */
    @Length(max = 100, message = "legalName长度不能超过100")
    private String legalName;

    /**
     * 法人手机号
     * 企业子户同步开通银行账户必填
     * (选填)
     */
    @Length(max = 20, message = "legalMobile长度不能超过20")
    private String legalMobile;

    /**
     * 法人证件类型
     * 企业子户同步开通银行账户必填
     * (选填)
     */
    @Length(max = 2, message = "legalCertTp长度不能超过2")
    private String legalCertTp;

    /**
     * 法人证件号
     * 企业子户同步开通银行账户必填
     * (选填)
     */
    @Length(max = 40, message = "legalCertNo长度不能超过40")
    private String legalCertNo;

    /**
     * 法人证件有效期起始日
     * 企业子户同步开通银行账户必填
     * (选填)
     */
    @Length(max = 10, message = "legalValidateStart长度不能超过10")
    private String legalValidateStart;

    /**
     * 法人证件有效期到期日
     * 企业子户同步开通银行账户必填
     * (选填)
     */
    @Length(max = 10, message = "legalValidateEnd长度不能超过10")
    private String legalValidateEnd;

    /**
     * 法人证件照片正面
     * 企业子户同步开通银行账户必填 channel=04/06 时，必填
     * (选填)
     */
    private String legalImagF;

    /**
     * 法人证件照片反面
     * 企业子户同步开通银行账户必填 channel=04/06 时，必填
     * (选填)
     */
    private String legalImagB;

    /**
     * 手机号
     * 个人或企业联系人手机号，需实名
     * (必填)
     */
    @NotBlank
    @Length(max = 20, message = "mobile长度不能超过20")
    private String mobile;

    /**
     * 联系人姓名
     * 企业子户同步开通银行账户必填
     * (选填)
     */
    private String contactName;

    /**
     * 联系人邮箱
     * 企业子户同步开通银行账户必填
     * (选填)
     */
    @Length(max = 20, message = "contactEmail长度不能超过20")
    private String contactEmail;

    /**
     * 联系人身份证号
     * 企业子户同步开通银行账户必填
     * (选填)
     */
    @Length(max = 30, message = "contactCertNo长度不能超过30")
    private String contactCertNo;

    /**
     * 银行账号
     * 企业必填
     * (选填)
     */
    @Length(max = 40, message = "outAcntNo长度不能超过40")
    private String outAcntNo;

    /**
     * 开户行行号
     * 企业账户开户行行号必填 另提供附件《开户行信息列表》
     * (选填)
     */
    @Length(max = 12, message = "interBankNo长度不能超过12")
    private String interBankNo;

    /**
     * 分账比例
     * 10000 表示 100%,500 表示 5%.不传，默认同商户最大分账比例
     * (选填)
     */
    private Integer allocateScale;

    /**
     * 协议类型
     * 协议类型
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "protocolType长度不能超过30")
    private String protocolType;

    /**
     * 商户用户 id
     * 商户用户 id
     * (必填)
     */
    @NotBlank
    @Length(max = 50, message = "mchntCdUserId长度不能超过50")
    private String mchntCdUserId;

    /**
     * 验证类型
     * 验证类型
     * (选填)
     */
    @Length(max = 1, message = "checkType长度不能超过1")
    private String checkType;

}