/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.steward.request.account;

import lombok.Data;
import org.hibernate.validator.constraints.Length;
import com.fshows.steward.request.FuStewardBizRequest;

import javax.validation.constraints.NotBlank;

/**
 * 商户账户余额查询接口
 *
 * @author
 * @version FuStdCustomerBalanceQueryReq.java, v 0.1 2023-12-28 17:24:56
 */
@Data
public class FuStdCustomerBalanceQueryReq extends FuStewardBizRequest {

    private static final long serialVersionUID = -2213838555254973039L;


    /**
     * 商户流水号
     * 唯一流水号，商户定义
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "traceNo长度不能超过30")
    private String traceNo;




}