/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.steward.request.account;

import com.fshows.sdk.core.client.base.definition.IRequestDefinition;
import lombok.Data;
import org.hibernate.validator.constraints.Length;
import com.fshows.steward.request.FuStewardBizRequest;
import javax.validation.constraints.NotNull;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 用户激活、短信重发接口
 *
 * @author
 * @version FuStdActiveCustomerReq.java, v 0.1 2023-12-28 15:31:24
 */
@Data
public class FuStdActiveCustomerReq extends FuStewardBizRequest {

    private static final long serialVersionUID = -2213838555762135508L;


    /**
     * 商户流水号
     * 唯一流水号，商户定义
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "traceNo长度不能超过30")
    private String traceNo;

    /**
     * 用户编号
     * 用户编号
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "accountIn长度不能超过30")
    private String accountIn;

    /**
     * 验证类型
     * 1 短信模式； 2 返回 url 不传默认 1
     * (选填)
     */
    @Length(max = 1, message = "checkType长度不能超过1")
    private String checkType;

}