package com.fshows.steward.apienum;

import com.fshows.fuiou.constant.FuiouConstant;
import com.fshows.fuiou.request.merchant.FuiouEquipmentUnBindRequest;
import com.fshows.fuiou.response.merchant.FuiouEquipmentUnBindResponse;
import com.fshows.sdk.core.client.base.definition.IApiDefinition;
import com.fshows.steward.contant.FuiouStewardContant;
import com.fshows.steward.enums.FuStewardApiTypeEnum;
import com.fshows.steward.request.account.FuStdActiveCustomerReq;
import com.fshows.steward.request.account.FuStdAddConcentrateRelationReq;
import com.fshows.steward.request.account.FuStdBalanceQueryReq;
import com.fshows.steward.request.account.FuStdCancleConcentrateRelationApplyReq;
import com.fshows.steward.request.account.FuStdCancleConcentrateRelationReq;
import com.fshows.steward.request.account.FuStdCloneCustomerReq;
import com.fshows.steward.request.account.FuStdCreateSubAccountReq;
import com.fshows.steward.request.account.FuStdCustomerBalanceQueryReq;
import com.fshows.steward.request.account.FuStdCustomerCreateReq;
import com.fshows.steward.request.account.FuStdDeteleCustomerReq;
import com.fshows.steward.request.account.FuStdModifyCustomerBankCardReq;
import com.fshows.steward.request.account.FuStdModifyProtocolReq;
import com.fshows.steward.request.account.FuStdQueryBankAccountReq;
import com.fshows.steward.request.account.FuStdQueryConcentrateRelationReq;
import com.fshows.steward.request.query.FuStdQueryAllocateAccountReq;
import com.fshows.steward.request.query.FuStdQueryBookTradeReq;
import com.fshows.steward.request.query.FuStdQueryElectronicVoucherReq;
import com.fshows.steward.request.trade.FuStdAccountInAutoDrawoutRepairReq;
import com.fshows.steward.request.trade.FuStdAccountInDrawoutReq;
import com.fshows.steward.request.trade.FuStdAccountInTransferToMchntRefundReq;
import com.fshows.steward.request.trade.FuStdAccountInTransferToMchntReq;
import com.fshows.steward.request.trade.FuStdBalanceAllocateReq;
import com.fshows.steward.request.trade.FuStdBatchTradeAllocateReq;
import com.fshows.steward.request.trade.FuStdBatchTradeConcentrateReq;
import com.fshows.steward.request.trade.FuStdCancleConcentrateTradeReq;
import com.fshows.steward.request.trade.FuStdMchntBalanceConcentrateReq;
import com.fshows.steward.request.trade.FuStdMchntDrawoutReq;
import com.fshows.steward.request.trade.FuStdRechargeTradeAllocateReq;
import com.fshows.steward.request.trade.FuStdRefundConcentrateTradeReq;
import com.fshows.steward.request.trade.FuStdSubAccountInTransferAsynReq;
import com.fshows.steward.request.trade.FuStdTradeAllocateCancelReq;
import com.fshows.steward.request.trade.FuStdTradeAllocateRefundReq;
import com.fshows.steward.response.account.FuStdActiveCustomerRes;
import com.fshows.steward.response.account.FuStdAddConcentrateRelationRes;
import com.fshows.steward.response.account.FuStdBalanceQueryRes;
import com.fshows.steward.response.account.FuStdCancleConcentrateRelationApplyRes;
import com.fshows.steward.response.account.FuStdCancleConcentrateRelationRes;
import com.fshows.steward.response.account.FuStdCloneCustomerRes;
import com.fshows.steward.response.account.FuStdCreateSubAccountRes;
import com.fshows.steward.response.account.FuStdCustomerCreateRes;
import com.fshows.steward.response.account.FuStdDeteleCustomerRes;
import com.fshows.steward.response.account.FuStdModifyCustomerBankCardRes;
import com.fshows.steward.response.account.FuStdModifyProtocolRes;
import com.fshows.steward.response.account.FuStdQueryBankAccountRes;
import com.fshows.steward.response.account.FuStdQueryConcentrateRelationRes;
import com.fshows.steward.response.query.FuStdQueryBookTradeRes;
import com.fshows.steward.response.query.FuStdQueryElectronicVoucherRes;
import com.fshows.steward.response.query.account.FuStdQueryAllocateAccountRes;
import com.fshows.steward.response.trade.FuStdAccountInAutoDrawoutRepairRes;
import com.fshows.steward.response.trade.FuStdAccountInDrawoutRes;
import com.fshows.steward.response.trade.FuStdAccountInTransferToMchntRefundRes;
import com.fshows.steward.response.trade.FuStdAccountInTransferToMchntRes;
import com.fshows.steward.response.trade.FuStdBalanceAllocateRes;
import com.fshows.steward.response.trade.FuStdBatchTradeAllocateRes;
import com.fshows.steward.response.trade.FuStdBatchTradeConcentrateRes;
import com.fshows.steward.response.trade.FuStdCancleConcentrateTradeRes;
import com.fshows.steward.response.trade.FuStdMchntBalanceConcentrateRes;
import com.fshows.steward.response.trade.FuStdMchntDrawoutRes;
import com.fshows.steward.response.trade.FuStdRechargeTradeAllocateRes;
import com.fshows.steward.response.trade.FuStdRefundConcentrateTradeRes;
import com.fshows.steward.response.trade.FuStdSubAccountInTransferAsynRes;
import com.fshows.steward.response.trade.FuStdTradeAllocateCancelRes;
import com.fshows.steward.response.trade.FuStdTradeAllocateRefundRes;

/**
 * 富友富管家相关API
 *
 * @author liluqing
 * @version FuiouSettlementApiDefinitionEnum.java, v 0.1 2022-03-01 21:53 liluqing
 */
public enum FuStewardApiDefinitionEnum implements IApiDefinition {

    /************************************************  开户相关接口  *****************************************************/

    CREATE_CUSTOMER(
            "用户创建接口",
            "V2/openAccount.fuiou",
            FuStewardApiTypeEnum.ENCRYPT_API,
            null,
            null
    ),
    DETELE_CUSTOMER(
            "用户删除接口",
            "/invalidAllocateAccount.fuiou",
            FuStewardApiTypeEnum.NORMAL_API,
            FuStdDeteleCustomerReq.class,
            FuStdDeteleCustomerRes.class
    ),
    ACTIVE_CUSTOMER(
            "用户激活、短信重发接口",
            "/activeAllocateAccount.fuiou",
            FuStewardApiTypeEnum.NORMAL_API,
            FuStdActiveCustomerReq.class,
            FuStdActiveCustomerRes.class
    ),
    MODIFY_CUSTOMER_BANK_CARD(
            "用户绑/解卡接口",
            "/modifyAccountInCard.fuiou",
            FuStewardApiTypeEnum.NORMAL_API,
            FuStdModifyCustomerBankCardReq.class,
            FuStdModifyCustomerBankCardRes.class
    ),
    MODIFY_PROTOCOL(
            "普通入账方协议修改接口",
            "/modifyProtocol.fuiou",
            FuStewardApiTypeEnum.NORMAL_API,
            FuStdModifyProtocolReq.class,
            FuStdModifyProtocolRes.class
    ),
    CREATE_SUB_ACCOUNT(
            "商户自有子账户创建接口",
            "/createSubAccount.fuiou",
            FuStewardApiTypeEnum.NORMAL_API,
            FuStdCreateSubAccountReq.class,
            FuStdCreateSubAccountRes.class
    ),
    CLONE_CUSTOMER(
            "用户子账户创建接口（账户模式）",
            "/cloneAccountIn.fuiou",
            FuStewardApiTypeEnum.NORMAL_API,
            FuStdCloneCustomerReq.class,
            FuStdCloneCustomerRes.class
    ),
    ADD_CONCENTRATE_RELATION(
            "归集授权申请接口",
            "/addConcentrateRelation.fuiou",
            FuStewardApiTypeEnum.NORMAL_API,
            FuStdAddConcentrateRelationReq.class,
            FuStdAddConcentrateRelationRes.class
    ),
    CANCLE_CONCENTRATE_RELATION_APPLY(
            "归集授权申请撤销接口",
            "/cancleConcentrateRelationApply.fuiou",
            FuStewardApiTypeEnum.NORMAL_API,
            FuStdCancleConcentrateRelationApplyReq.class,
            FuStdCancleConcentrateRelationApplyRes.class
    ),
    CANCLE_CONCENTRATE_RELATION(
            "归集关系取消接口",
            "/cancleConcentrateRelation.fuiou",
            FuStewardApiTypeEnum.NORMAL_API,
            FuStdCancleConcentrateRelationReq.class,
            FuStdCancleConcentrateRelationRes.class
    ),

    /************************************************  交易相关接口  *****************************************************/

    BATCH_TRADE_ALLOCATE(
            "订单分账接口",
            "/batchTradeAllocate.fuiou",
            FuStewardApiTypeEnum.NORMAL_API,
            FuStdBatchTradeAllocateReq.class,
            FuStdBatchTradeAllocateRes.class
    ),

    BALANCE_ALLOCATE(
            "余额分账接口",
            "/balanceAllocate.fuiou",
            FuStewardApiTypeEnum.NORMAL_API,
            FuStdBalanceAllocateReq.class,
            FuStdBalanceAllocateRes.class
    ),
    TRADE_ALLOCATE_REFUND(
            "分账交易退回",
            "/V2/tradeAllocateRefund.fuiou",
            FuStewardApiTypeEnum.NORMAL_API,
            FuStdTradeAllocateRefundReq.class,
            FuStdTradeAllocateRefundRes.class
    ),
    RECHARGE_TRADE_ALLOCATE(
            "充值记账接口",
            "/rechargeTradeAllocate.fuiou",
            FuStewardApiTypeEnum.NORMAL_API,
            FuStdRechargeTradeAllocateReq.class,
            FuStdRechargeTradeAllocateRes.class
    ),
    TRADE_ALLOCATE_CANCEL(
            "充值记账撤销接口",
            "/tradeAllocateCancel.fuiou",
            FuStewardApiTypeEnum.NORMAL_API,
            FuStdTradeAllocateCancelReq.class,
            FuStdTradeAllocateCancelRes.class
    ),

    ACCOUNT_IN_TRANSFER_TO_MCHNT(
            "转账记账接口",
            "/accountInTransferToMchnt.fuiou",
            FuStewardApiTypeEnum.NORMAL_API,
            FuStdAccountInTransferToMchntReq.class,
            FuStdAccountInTransferToMchntRes.class
    ),
    ACCOUNT_IN_TRANSFER_TO_MCHNT_REFUND(
            "转账记账退回接口",
            "/accountInTransferToMchntRefund.fuiou",
            FuStewardApiTypeEnum.NORMAL_API,
            FuStdAccountInTransferToMchntRefundReq.class,
            FuStdAccountInTransferToMchntRefundRes.class
    ),
    SUB_ACCOUNT_IN_TRANSFER_ASYN(
            "用户间转账记账接口（异步）",
            "/subAccountInTransferAsyn.fuiou",
            FuStewardApiTypeEnum.NORMAL_API,
            FuStdSubAccountInTransferAsynReq.class,
            FuStdSubAccountInTransferAsynRes.class
    ),

    ACCOUNT_IN_AUTO_DRAWOUT_REPAIR(
            "用户自动结算重跑接口",
            "/accountInAutoDrawoutRepair.fuiou",
            FuStewardApiTypeEnum.NORMAL_API,
            FuStdAccountInAutoDrawoutRepairReq.class,
            FuStdAccountInAutoDrawoutRepairRes.class
    ),
    ACCOUNT_IN_DRAWOUT(
            "用户委托结算接口",
            "/accountInDrawout.fuiou",
            FuStewardApiTypeEnum.NORMAL_API,
            FuStdAccountInDrawoutReq.class,
            FuStdAccountInDrawoutRes.class
    ),
    MCHNT_DRAWOUT(
            "商户结算接口",
            "/mchntDrawout.fuiou",
            FuStewardApiTypeEnum.NORMAL_API,
            FuStdMchntDrawoutReq.class,
            FuStdMchntDrawoutRes.class
    ),
    BATCH_TRADE_CONCENTRATE(
            "订单批量归集接口",
            "/batchTradeConcentrate.fuiou",
            FuStewardApiTypeEnum.NORMAL_API,
            FuStdBatchTradeConcentrateReq.class,
            FuStdBatchTradeConcentrateRes.class
    ),
    MCHNT_BALANCE_CONCENTRATE(
            "商户资金归集接口",
            "/mchntBalanceConcentrate.fuiou",
            FuStewardApiTypeEnum.NORMAL_API,
            FuStdMchntBalanceConcentrateReq.class,
            FuStdMchntBalanceConcentrateRes.class
    ),
    CANCLE_CONCENTRATE_TRADE(
            "归集撤销接口",
            "/cancleConcentrateTrade.fuiou",
            FuStewardApiTypeEnum.NORMAL_API,
            FuStdCancleConcentrateTradeReq.class,
            FuStdCancleConcentrateTradeRes.class
    ),
    REFUND_CONCENTRATE_TRADE(
            "归集退回接口",
            "/refundConcentrateTrade.fuiou",
            FuStewardApiTypeEnum.NORMAL_API,
            FuStdRefundConcentrateTradeReq.class,
            FuStdRefundConcentrateTradeRes.class
    ),


    /************************************************  查询相关接口  *****************************************************/

    CUSTOMER_IN_BALANCE_QUERY(
            "用户记账户余额查询接口",
            "/queryAccountInBalance.fuiou",
            FuStewardApiTypeEnum.NORMAL_API,
            FuStdCustomerBalanceQueryReq.class,
            FuStdCustomerBalanceQueryReq.class
    ),
    BALANCE_QUERY(
            "商户账户余额查询接口",
            "/queryMchntAccountBalance.fuiou",
            FuStewardApiTypeEnum.NORMAL_API,
            FuStdBalanceQueryReq.class,
            FuStdBalanceQueryRes.class
    ),
    CUSTOMER_CREATE(
            "用户创建接口",
            "/V2/openAccount.fuiou",
            FuStewardApiTypeEnum.ENCRYPT_API,
            FuStdCustomerCreateReq.class,
            FuStdCustomerCreateRes.class
    ),
    QUERY_CONCENTRATE_RELATION(
            "归集关系查询接口",
            "/queryConcentrateRelation.fuiou",
            FuStewardApiTypeEnum.NORMAL_API,
            FuStdQueryConcentrateRelationReq.class,
            FuStdQueryConcentrateRelationRes.class
    ),
    QUERY_BANK_ACCOUNT(
            "商户银行账户信息查询接口",
            "/queryBankAccount.fuiou",
            FuStewardApiTypeEnum.NORMAL_API,
            FuStdQueryBankAccountReq.class,
            FuStdQueryBankAccountRes.class
    ),
    QUERY_BOOK_TRADE(
            "记账类交易结果查询接口",
            "/queryBookkeepingTrade.fuiou",
            FuStewardApiTypeEnum.NORMAL_API,
            FuStdQueryBookTradeReq.class,
            FuStdQueryBookTradeRes.class
    ),

    ELECTRONIC_VOUCHER(
            "下载电子回单",
            "/queryTradeCertificate.fuiou",
            FuStewardApiTypeEnum.NORMAL_API,
            FuStdQueryElectronicVoucherReq.class,
            FuStdQueryElectronicVoucherRes.class
    ),
    QUERY_ALLOCATE_ACCOUNT(
            "用户状态查询",
            "/V2/queryAllocateAccount.fuiou",
            FuStewardApiTypeEnum.ENCRYPT_API,
            FuStdQueryAllocateAccountReq.class,
            FuStdQueryAllocateAccountRes.class
    ),
    ;

    /**
     * 接口名称
     */
    private String name;
    /**
     * 接口uri子资源路径
     */
    private String apiSubURI;
    /**
     * 接口类型，标识接口是否加密
     */
    private FuStewardApiTypeEnum apiTypeEnum;
    /**
     * 请求业务参数的Class类型
     */
    private Class requestClass;
    /**
     * 响应业务参数的Class类型
     */
    private Class responseClass;


    FuStewardApiDefinitionEnum(String name,
                               String apiSubURI,
                               FuStewardApiTypeEnum apiTypeEnum,
                               Class requestClass,
                               Class responseClass) {
        this.name = name;
        this.apiSubURI = apiSubURI;
        this.apiTypeEnum = apiTypeEnum;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    @Override
    public String getApiURI() {
        return apiSubURI;
    }


    @Override
    public String getVersion() {
        return FuiouStewardContant.DEFAULT_API_VERSION;
    }

    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }

    /**
     * Getter method for property <tt>apiTypeEnum</tt>.
     *
     * @return property value of apiTypeEnum
     */
    public FuStewardApiTypeEnum getApiTypeEnum() {
        return apiTypeEnum;
    }
}