/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.fuiou.client.impl;

import com.fshows.fuiou.client.base.ApiClientConfig;
import com.fshows.fuiou.client.base.FuiouHttpResult;
import com.fshows.fuiou.client.base.IHttpRequest;
import com.fshows.fuiou.util.FsHttpUtil;
import org.xml.sax.SAXException;

import javax.xml.parsers.ParserConfigurationException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/**
 * @author zhubo
 * @version MerchantHttpRequestImpl.java, v 0.1 2023-09-26 17:50 zhubo
 */
public class MerchantHttpRequestImpl implements IHttpRequest {
    @Override
    public FuiouHttpResult post(String url, String authorization, String requestBody, ApiClientConfig apiClientConfig) throws Exception {
        Map<String, String> headers = new HashMap<>();
        // headers.put("Authorization", authorization);

        Map<String, String> param = new HashMap<>();
        param.put("req", requestBody);
        String fsHttpResult = FsHttpUtil.post(
                url,
                param,
                apiClientConfig.getCharset(),
                null,
                apiClientConfig.getConnectionTimeout(),
                apiClientConfig.getReadTimeout(),
                headers);
        if (fsHttpResult != null) {
            return convertFuiouHttpResult(fsHttpResult, apiClientConfig);
        }
        return null;
    }

    /**
     * fsHttpResult 转>> FuiouHttpResult
     *
     * @param response        响应
     * @param apiClientConfig API客户端配置
     * @return {@link FuiouHttpResult}
     * @throws ParserConfigurationException 解析器配置异常
     * @throws IOException                  ioexception
     * @throws SAXException                 saxexception
     */
    private FuiouHttpResult convertFuiouHttpResult(String response, ApiClientConfig apiClientConfig) throws ParserConfigurationException, IOException, SAXException {
        FuiouHttpResult fuiouHttpResult = new FuiouHttpResult();
        fuiouHttpResult.setBody(response);
        return fuiouHttpResult;
    }
}
