/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.steward.response.trade;

import com.fshows.steward.response.FuStewardBizResponse;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 用户间转账记账接口（异步）
 *
 * @author
 * @version FuStdTradeAllocateRefundRes.java, v 0.1 2024-01-02 15:22:42
 */
@Data
public class FuStdSubAccountInTransferAsynRes extends FuStewardBizResponse {

    private static final long serialVersionUID = -3660708989469180208L;


    /**
     * 商户流水号
     *
     * (必填)
     */
    @NotBlank
    private String traceNo;

    /**
     * 转出入账方编号
     *
     * (必填)
     */
    @NotBlank
    private String accountOut;

}