/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.steward.response.trade;

import com.fshows.steward.annotation.NoSign;
import com.fshows.steward.response.FuStewardBizResponse;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 转账记账接口
 *
 * @author
 * @version FuStdAccountInTransferToMchntRes.java, v 0.1 2024-01-02 15:41:59
 */
@Data
public class FuStdAccountInTransferToMchntRes extends FuStewardBizResponse {

    private static final long serialVersionUID = -2213838555654712552L;


    /**
     * 商户流水号
     * 唯一流水号，商户定义
     * (必填)
     */
    @NotBlank
    private String traceNo;

    /**
     * 富友批次号
     * 富友批次号
     * (必填)
     */
    @NotBlank
    private String batchNo;

    /**
     * 转出用户编号
     * 转出用户编号
     * (必填)
     */
    @NotBlank
    private String accountIn;

    /**
     * 转账金额
     * 转账金额
     * (必填)
     */
    @NotNull
    private Integer amt;

    /**
     * 交易参考号
     * 后续发起对该笔交易的分账使用次参考号
     * (选填)
     */
    @NoSign
    private String srcFasSsn;

    /**
     * 交易日期
     * 交易日期
     * (选填)
     */
    @NoSign
    private String srcFasDate;

}