/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.steward.response.account;

import com.fshows.steward.response.FuStewardBizResponse;
import com.fshows.steward.response.account.item.QueryBankAccountItem;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * 归集关系查询接口
 *
 * @author
 * @version FuStdQueryConcentrateRelationRes.java, v 0.1 2024-01-10 15:18:03
 */
@Data
public class FuStdQueryBankAccountRes extends FuStewardBizResponse {

    private static final long serialVersionUID = 1445910911930202261L;


    /**
     * 交易流水号
     * 交易流水号
     * (必填)
     */
    @NotBlank
    private String traceNo;


    /**
     * 商户号
     */
    @NotBlank
    private String mchntCd;

    /**
     * 被归集商户号
     * 被归集商户在富友的唯一代码
     * (必填)
     */
    private String mchntCdConcentrate;


    /**
     * 归集信息
     */
    private List<QueryBankAccountItem> list;


}