/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.steward.response.account;

import com.fshows.sdk.core.client.base.definition.IResponseDefinition;
import com.fshows.steward.response.FuStewardBizResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 用户绑/解卡接口
 *
 * @author
 * @version FuStdModifyCustomerBankCardRes.java, v 0.1 2023-12-28 15:15:00
 */
@Data
public class FuStdModifyCustomerBankCardRes extends FuStewardBizResponse {

    private static final long serialVersionUID = -2213838555344498385L;


    /**
     * 商户流水号
     * 商户定义的唯一单号
     * (必填)
     */
    @NotBlank
    private String traceNo;

    /**
     * 用户编号
     * 用户编号
     * (必填)
     */
    @NotBlank
    private String accountIn;

    /**
     * 业务类型
     * 1 绑卡， 2 解绑
     * (必填)
     */
    @NotBlank
    private String type;

    /**
     * 开户行行号
     * 另提供附件《开户行信息列表》
     * (必填)
     */
    @NotBlank
    private String interBankNo;

    /**
     * 旷世验证 h5 链接
     * checkType 为 2 时返回
     * (选填)
     */
    private String ksCheckUrl;

    /**
     * 阿里验证 h5 链接
     * checkType 为 2 时返回
     * (选填)
     */
    private String checkUrl;

    /**
     * 银行账号
     * 银行账号
     * (必填)
     */
    @NotBlank
    private String outAcntNo;

}