/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.steward.response.account ;

import com.fshows.steward.response.FuStewardBizResponse;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 用户记账户余额查询接口
 *
 * @author
 * @version FuStdCustomerBalanceQueryRes.java, v 0.1 2023-12-28 17:17:48
 */
@Data
public class FuStdCustomerInBalanceQueryRes extends FuStewardBizResponse {

    private static final long serialVersionUID = -2213838555798270479L;


    /**
     * 商户流水号
     * 商户定义的唯一流水号
     * (必填)
     */
    @NotBlank
    private String traceNo;

    /**
     * 入账方编号
     * 用户编号
     * (必填)
     */
    @NotBlank
    private String accountIn;

    /**
     * 可用余额
     * 可用余额
     * (必填)
     */
    @NotNull
    private Integer availableBalance;

    /**
     * 冻结金额
     * 冻结金额
     * (必填)
     */
    @NotNull
    private Integer freezeBalance;

    /**
     * 账面金额
     * 账面金额
     * (必填)
     */
    @NotNull
    private Integer totalBalance;

    /**
     * 待转结金额
     * 待转结金额
     * (必填)
     */
    @NotNull
    private Integer waitingCarryBalance;

}