/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.steward.request.trade;

import com.fshows.steward.request.trade.item.FustdAccountInListReq;
import lombok.Data;
import org.hibernate.validator.constraints.Length;
import com.fshows.steward.request.FuStewardBizRequest;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * 余额分账接口
 *
 * @author
 * @version FuStdBalanceAllocateReq.java, v 0.1 2024-01-02 10:21:58
 */
@Data
public class FuStdBalanceAllocateReq extends FuStewardBizRequest {

    private static final long serialVersionUID = -2213838555843504231L;


    /**
     * 商户流水号
     * 唯一流水号，商户定义
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "traceNo长度不能超过30")
    private String traceNo;

    /**
     * 商户自有子账户编号
     * 不填默认商户主账户
     * (选填)
     */
    @Length(max = 30, message = "accountIn长度不能超过30")
    private String accountIn;

    /**
     * 入账方列表
     * 入账方列表
     * (选填)
     */
    private List<FustdAccountInListReq> accountInlist;



}