/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.steward.request.account;

import com.fshows.steward.request.FuStewardBizRequest;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 归集关系查询接口
 *
 * @author
 * @version FuStdQueryConcentrateRelationReq.java, v 0.1 2024-01-10 15:18:03
 */
@Data
public class FuStdQueryBankAccountReq extends FuStewardBizRequest {

    private static final long serialVersionUID = 5469674024884015589L;


    /**
     * 商户流水号
     * 唯一流水号，商户定义
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "traceNo长度不能超过30")
    private String traceNo;



    /**
     * 归集商户号
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "mchntCd长度不能超过30")
    private String mchntCd;

    /**
     * 被归集商户号
     * 被归集商户在富友的唯一代码
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "mchntCdConcentrate长度不能超过30")
    private String mchntCdConcentrate;

}