/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.steward.request.account;

import com.fshows.sdk.core.client.base.definition.IRequestDefinition;
import lombok.Data;
import org.hibernate.validator.constraints.Length;
import com.fshows.steward.request.FuStewardBizRequest;
import javax.validation.constraints.NotNull;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 普通入账方协议修改接口
 *
 * @author
 * @version FuStdModifyProtocolReq.java, v 0.1 2023-12-28 15:35:32
 */
@Data
public class FuStdModifyProtocolReq extends FuStewardBizRequest {

    private static final long serialVersionUID = -2213838555666003874L;


    /**
     * 商户流水号
     * 唯一流水号，商户定义
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "traceNo长度不能超过30")
    private String traceNo;

    /**
     * 入账方编号
     * 
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "accountIn长度不能超过30")
    private String accountIn;

    /**
     * 修改类型
     * 1 分账比例或协议类型， 2 手 机号 不传默认 1
     * (选填)
     */
    @Length(max = 1, message = "type长度不能超过1")
    private String type;

    /**
     * 分账比例
     * 如： 100% 传 10000
     * (必填)
     */
    @NotNull
    private Integer allocateScale;

    /**
     * 协议类型
     * 01 联合营销推广协议 02 平台入驻分账协议
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "protocolType长度不能超过30")
    private String protocolType;

    /**
     * 验证类型
     * 1 短信模式， 2 返回 url 不传默认 1
     * (选填)
     */
    @Length(max = 1, message = "checkType长度不能超过1")
    private String checkType;

    /**
     * 手机号码
     * 短信模式下，如手机号未传， 短信下发至开户手机号
     * (选填)
     */
    @Length(max = 20, message = "mobile长度不能超过20")
    private String mobile;

}