/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package
        com.fshows.steward;

import com.alibaba.fastjson.JSONObject;
import com.fshows.fuiou.util.FuiouRequestUtils;
import com.fshows.sdk.core.client.base.AbstractApiClient;
import com.fshows.sdk.core.client.base.handler.IApiSignHandler;
import com.fshows.sdk.core.client.base.handler.IHttpRequestHandler;
import com.fshows.sdk.core.client.base.handler.ISerializableHandler;
import com.fshows.sdk.core.client.base.model.ApiRequestModel;
import com.fshows.sdk.core.client.base.model.ApiResponseModel;
import com.fshows.sdk.core.client.base.model.ClientInfoModel;
import com.fshows.sdk.core.client.base.model.DefaultClientConfigModel;
import com.fshows.sdk.core.client.base.model.DefaultRequestContext;
import com.fshows.sdk.core.client.component.http.FromHttpRequestHandler;
import com.fshows.sdk.core.exception.FsApiException;
import com.fshows.sdk.core.util.LogUtil;
import com.fshows.steward.apienum.FuStewardApiDefinitionEnum;
import com.fshows.steward.component.FuStewardSerializableHandler;
import com.fshows.steward.handler.FuStewardSignHandler;
import com.fshows.steward.request.FuStewardBaseRequest;
import com.fshows.steward.request.FuStewardBizRequest;
import com.fshows.steward.response.FuStewardBaseResponse;
import lombok.extern.slf4j.Slf4j;

import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;

/**
 * 嵌套参数客户端模版
 * @author liluqing
 * @version NestTemplateApiClinet.java, v 0.1 2023-12-12 15:40
 */
@Slf4j
public class FuStewardApiClinet extends AbstractApiClient<FuStewardBizRequest, FuStewardBaseResponse, FuStewardApiDefinitionEnum> {

     /**
      * 加签验签处理器
      */
    protected IApiSignHandler iApiSignHandler = new FuStewardSignHandler();

     /**
      * 序列化处理器
      */
     protected ISerializableHandler paramSerializable = new FuStewardSerializableHandler();

     /**
      * 请求执行器
      */
     protected IHttpRequestHandler httpRequestHandler = new FromHttpRequestHandler();

    public FuStewardApiClinet(DefaultClientConfigModel apiClientConfig) throws FsApiException {
        super(apiClientConfig);
    }

     /**
      * 构建请求参数
      *
      * @param request
      * @param context
      * @return
      */
    @Override
    protected ApiRequestModel buildApiRequestModel(FuStewardBizRequest request, DefaultRequestContext context) {
        // 1. 设置网关地址  2. 请求参数填充  3. 请求加签  4. 请求参数序列化
        // sdk客户端配置
        DefaultClientConfigModel clientConfig = context.getApiClientConfig();

        ApiRequestModel apiRequestModel = new ApiRequestModel();
        // 设置网关地址
        apiRequestModel.setApiURL(context.getApiClientConfig().getApiParentURL() + context.getIApiDefinition().getApiURI());

        // 补充业务参数入参
        request.setMchntCd(clientConfig.getAppId());
        // 设置加签过滤字符串
        context.setNoNeedSignWords(FuiouRequestUtils.getNoNeedSign(request.getClass()));
        // 请求加签处理
        //Map<String, Object> stringObjectMap = toMapObj(request, apiClientConfig.isHump(),false);
        Map<String, Object> stringObjectMap = FuiouRequestUtils.ObjectToMap(request);

        apiRequestModel.setParamMap(new TreeMap<>(stringObjectMap));
        apiRequestModel.setRequest(request);
        // 获取签名
        apiRequestModel.setRequestSign(iApiSignHandler.sign(apiRequestModel, context));
        // 设置签名
        Map<String, Object> paramMap = apiRequestModel.getParamMap();
        paramMap.put("signature", apiRequestModel.getRequestSign());

        // 补充参数构建实际的请求入参
        FuStewardBaseRequest fuStewardBaseRequest = new FuStewardBaseRequest();
        fuStewardBaseRequest.setMchntCd(clientConfig.getAppId());
        fuStewardBaseRequest.setSignature(apiRequestModel.getRequestSign());
        fuStewardBaseRequest.setData(request);
        apiRequestModel.setRequest(fuStewardBaseRequest);

        // 参数序列化
        String requestBody = paramSerializable.serializeObject(apiRequestModel, context);
        apiRequestModel.setRequestBody(requestBody);


        return apiRequestModel;
    }

     /**
      * 处理客户端信息
      *
      * @return
      */
    @Override
    protected ClientInfoModel getClientInfo() {
        // todo: 变更SDK名字,作用于日志打印
        ClientInfoModel clientInfoModel = new ClientInfoModel();
        clientInfoModel.setClientCode("fuiou-sdk");
        clientInfoModel.setClientName("富友分账");
        return clientInfoModel;
    }

     @Override
     protected FuStewardBaseResponse buildApiResponse(ApiResponseModel apiResponseModel, ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) {
         // todo: 一般来说该方法需要完成以下事项
         // 1.  2. 请求参数填充  3. 请求加签  4. 参数反序列化
         // 客户端配置
         DefaultClientConfigModel apiClientConfigModel = requestContext.getApiClientConfig();
         apiResponseModel.setResponse(paramSerializable.deserializationResponse(apiResponseModel, apiRequestModel, requestContext));
         // 获取加签需过滤字段
         requestContext.setNoNeedSignWords(FuiouRequestUtils.getNoNeedSign(requestContext.getIApiDefinition().getResponseClass()));
         LogUtil.info(log, "{} >> 请求结束【明文参数】 >> url={}, method={}, request={}, response={}", new Object[]{requestContext.getClientInfoModel().getClientDesc(), apiRequestModel.getApiURL(), requestContext.getIApiDefinition(), JSONObject.toJSONString(apiRequestModel.getParamMap()), JSONObject.toJSONString(apiResponseModel.getResponse())});
         // 是否验签
         Boolean verifySign = iApiSignHandler.verifySign(apiResponseModel, apiRequestModel,  requestContext);
         if (apiClientConfigModel.isVrifySignResponse() && !Boolean.TRUE.equals(verifySign)) {
             throw new FsApiException("验签失败");
         }
         return (FuStewardBaseResponse) apiResponseModel.getResponse();
     }

     @Override
    protected ApiResponseModel httpRequest(ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) throws IOException {
        return httpRequestHandler.httpRequest(apiRequestModel, requestContext);
    }

    @Override
    public FuStewardBaseResponse execute(FuStewardBizRequest request, FuStewardApiDefinitionEnum apiDefinition) throws FsApiException {
        return super.doExecute(request, apiDefinition);
    }

    @Override
    public FuStewardBaseResponse execute(FuStewardBizRequest request, FuStewardApiDefinitionEnum apiDefinition, DefaultClientConfigModel configModel) throws FsApiException {
        return super.doExecute(request, apiDefinition, configModel);
    }

}