/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.fuiou.response.settlement;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.fuiou.response.base.FuiouBizResponse;
import lombok.Data;
import java.io.Serializable;

/**
 * @author zhaoxumin
 * @version FuiouWithdrawResponse.java, v 0.1 2024-01-07 zhaoxumin
 */
@Data
public class FuiouWithdrawResponse extends FuiouBizResponse implements Serializable {

    private static final long serialVersionUID = 3215997252371916783L;
    /**
     * 返回状态码, SUCCESS/FAILED，此字段是通信标识，非交易标识，交易是否成功需要查看result_code来判断
     */
    @JSONField(name = "return_code")
    private String returnCode;

    /**
     * 返回信息, 返回错误原因
     */
    @JSONField(name = "return_msg")
    private String returnMsg;

    /**
     * 机构号,接入机构在富友的唯一代码
     */
    @JSONField(name = "ins_cd")
    private String insCd;

    /**
     * 商户号
     */
    @JSONField(name = "mchnt_cd")
    private String mchntCd;

    /**
     * 随机字符串
     */
    @JSONField(name = "random_str")
    private String randomStr;

    /**
     * 签名, 详见签名生成算法
     */
    @JSONField(name = "sign")
    private String sign;

    /**
     * 业务结果, SUCCESS/FAIL
     */
    @JSONField(name = "result_code")
    private String resultCode;

    /**
     * 错误代码, 0000成功,其他详细参见错误列表
     */
    @JSONField(name = "err_code")
    private String errCode;

    /**
     * 错误代码描述
     */
    @JSONField(name = "err_code_des")
    private String errCodeDes;

    /**
     * 富友本地跟踪号
     */
    @JSONField(name = "reserved_fy_trace_no")
    private String reservedFyTraceNo;
}