/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.fuiou.response.settlement;

import lombok.Data;

import java.io.Serializable;

/**
 * @author zhaoxumin
 * @version FuiouQuerySettlementTxnResponse.java, v 0.1 2024-01-07 zhaoxumin
 */
@Data
public class FuiouQuerySettlementTxnResponse implements Serializable {

    private static final long serialVersionUID = -391422560682583817L;
    /**
     * 商户号
     */
    private String srcMchntCd;

    /**
     * 流水号
     */
    private String kbpsTraceNo;

    /**
     * 金额（分）（除去手续费，实际到账金额）
     */
    private Long destTxnAmt;

    /**
     * 手续费
     */
    private Long txnFeeAmt;

    /**
     * 合并结算类型返回，未转结金额部分
     *
     * (非必填)
     */
    private Long notSettleAmt;

    /**
     * 发起结算时间，格式为：yyyyMMddHHmmss
     */
    private String txnRcvTs;

    /**
     * 清算日期，格式为：yyyyMMdd
     */
    private String kbpsSrcSettleDt;

    /**
     * 结算状态:
     * 1：成功
     * 2：超时
     * 3：失败
     *
     * (非必填)
     */
    private String paySt;

    /**
     * 结算状态描述
     *
     * (必填)
     */
    private String payStDesc;

    /**
     * 结算失败时，失败的原因
     *
     * (非必填)
     */
    private String payMsg;

    /**
     * 入账卡户名
     *
     * (非必填)
     */
    private String acntNm;

    /**
     * 入账卡号
     *
     * (非必填)
     */
    private String acntNo;

    /**
     * 入账卡开户行名称
     *
     * (非必填)
     */
    private String issBankNm;
}