/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.fuiou.response.merchant.item;

import lombok.Data;

import java.io.Serializable;

/**
 * @author zhubo
 * @version WechatConfigInfoResponse.java, v 0.1 2023-09-14 17:38 zhubo
 */
@Data
public class FuiouWechatConfigInfoResponse implements Serializable {
    private static final long serialVersionUID = -6148728519033499322L;

    /**
     * 富友商户号
     * (选填)
     */
    private String mchntCd;

    /**
     * 渠道商户号
     * (选填)
     */
    private String merchantNo;

    /**
     * 子商户公众账号 JSAPI 支付授权目录响应代码
     * (选填)
     */
    private String jsapiCode;

    /**
     * 子商户公众账号 JSAPI 支付授权目录响应描述
     * (选填)
     */
    private String jsapiMsg;

    /**
     * 子商户 SubAPPID 响应代码
     * (选填)
     */
    private String subAppidCode;

    /**
     * 子商户 SubAPPID 响应描述
     * (选填)
     */
    private String subAppidMsg;

    /**
     * 子商户推荐关注公众账号 APPID 响应代码
     * (选填)
     */
    private String subscribeAppidCode;

    /**
     * 子商户推荐关注公众账号 APPID 响应描述
     * (选填)
     */
    private String subscribeAppidMsg;

}
