/*
 * ailike.com
 * Copyright (C) 2022-2023 All Rights Reserved.
 */
package com.fshows.fuiou.response.bank;

import lombok.Data;

/**
 * @author zhangling
 * @version QueryReliefRemainDetailSdkResponse.java, v 0.1 2023-11-27 11:39 zhangling
 */
@Data
public class QueryReliefRemainDetailSdkResponse {
    /**
     * 商户号(组)
     */
    private String mchntCd;
    /**
     * 商户(组)名称
     */
    private String mchntName;
    /**
     * 门店ID
     */
    private String shopId;
    /**
     * 门店名称
     */
    private String shopName;
    /**
     * 商户数量
     */
    private String mchntNum;
    /**
     * 活动ID
     */
    private String activeId;
    /**
     * 活动名称
     */
    private String activeName;
    /**
     * 活动主体
     */
    private String activeOwner;
    /**
     * 活动主体名称
     */
    private String activeOwnerName;
    /**
     * 活动类型
     */
    private String activeType;
    /**
     * 月份
     */
    private String month;
    /**
     * 减免周期开始日
     */
    private String cfgStartDt;
    /**
     * 减免周期结束日
     */
    private String cfgEndDt;
    /**
     * 额度包配置模式 1-民生模式；2-新模式
     */
    private String limitCfgTp;
    /**
     * 总额度
     */
    private String totalAmt;
    /**
     * 已优惠总额度
     */
    private String totalAmtUsed;
    /**
     * 剩余总额度
     */
    private String totalAmtRemain;
    /**
     * 信用卡额度
     */
    private String creditCardAmt;
    /**
     * 已优惠信用卡额度
     */
    private String creditCardAmtUsed;
    /**
     * 信用卡剩余额度
     */
    private String creditCardAmtRemain;
    /**
     * 扫码额度
     */
    private String scanCodeAmt;
    /**
     * 已优惠扫码额度
     */
    private String scanCodeAmtUsed;
    /**
     * 剩余扫码额度
     */
    private String scanCodeAmtRemain;
    /**
     * 刷卡额度
     */
    private String payCardAmt;
    /**
     * 已优惠刷卡额度
     */
    private String payCardAmtUsed;
    /**
     * 剩余刷卡额度
     */
    private String payCardAmtRemain;
    /**
     * 借记卡额度
     */
    private String debitCardAmt;
    /**
     * 已优惠借记卡额度
     */
    private String debitCardAmtUsed;
    /**
     * 剩余借记卡额度
     */
    private String debitCardAmtRemain;
    /**
     * 活动状态 0 暂未生效 ；1 正常； 2 停止； 3已过期; 4 已失效
     */
    private String cfgStatus;
    /**
     * 当月是否变更过额度
     */
    private String isMdy;
}