/*
 * ailike.com
 * Copyright (C) 2022-2023 All Rights Reserved.
 */
package com.fshows.fuiou.response.bank;

import lombok.Data;

/**
 * @author zhangling
 * @version QueryReliefCfgDetailSdkResponse.java, v 0.1 2023-11-27 11:21 zhangling
 */
@Data
public class QueryReliefCfgDetailSdkResponse {
    /**
     * 批次号
     */
    private String batchNumber;
    /**
     * 商户号(组)
     */
    private String mchntCd;
    /**
     * 商户(组)名称
     */
    private String mchntName;
    /**
     * 门店ID
     */
    private String shopId;
    /**
     * 门店名称
     */
    private String shopName;
    /**
     * 商户数量
     */
    private String mchntNum;
    /**
     * 活动ID
     */
    private String activeId;
    /**
     * 活动名称
     */
    private String activeName;
    /**
     * 活动主体
     */
    private String activeOwner;
    /**
     * 活动主体名称
     */
    private String activeOwnerName;
    /**
     * 活动类型
     */
    private String activeType;
    /**
     * 月份
     */
    private String month;
    /**
     * 减免周期开始日
     */
    private String cfgStartDt;
    /**
     * 减免周期结束日
     */
    private String cfgEndDt;
    /**
     * 是否当前减免配置 0-否，1-是
     */
    private String inUse;
    /**
     * 优先级
     */
    private String prior;
    /**
     * 额度包配置模式 1-民生模式；2-新模式
     */
    private String limitCfgTp;
    /**
     * 总额度/扫码额度交易模板
     */
    private String scanCodeTp;
    /**
     * 总额度
     */
    private String totalAmt;
    /**
     * 信用卡额度
     */
    private String creditCardAmt;
    /**
     * 信用卡交易模板
     */
    private String creditCardTp;
    /**
     * 扫码额度
     */
    private String scanCodeAmt;
    /**
     * 刷卡额度
     */
    private String payCardAmt;
    /**
     * 刷卡交易模版
     */
    private String payCardTp;
    /**
     * 借记卡额度
     */
    private String debitCardAmt;
    /**
     * 借记卡交易模版
     */
    private String debitCardTp;
    /**
     * 活动状态 0 暂未生效 ；1 正常； 2 停止； 3已过期; 4 已失效
     */
    private String cfgStatus;
    /**
     * 审核状态 01-待审核，02-审核通过，03-审核不通过
     */
    private String auditSt;
    /**
     * 审核时间
     */
    private String rowDealTs;
    /**
     * 提交方
     */
    private String systemTp;
    /**
     * 停止类型： 01 立即停止；02- 定时停止
     */
    private String stopType;
    /**
     * 停止时间
     */
    private String stopTime;
}