/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.fuiou.request.trade.order;

import com.fshows.fuiou.response.trade.order.FuiouRefundResponse;
import lombok.Data;
import com.fshows.fuiou.request.base.FuiouBizRequest;
import com.fshows.fuiou.enums.FuiouApiDefinitionEnum;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import org.hibernate.validator.constraints.Length;

/**
 *
 *
 * @author
 * @version FuiouRefundRequest.java, v 0.1 2023-07-05 11:20:54
 */
@Data
public class FuiouRefundRequest extends FuiouBizRequest<FuiouRefundResponse, FuiouApiDefinitionEnum> implements Serializable {

    private static final long serialVersionUID = -2213838555299524123L;


    /**
     * 商户号,富友分配给二级商户的商户号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 15, message = "mchntCd长度不能超过15")
    private String mchntCd;

    /**
     * 终端号(没有真实终端号统一填88888888)
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 8, message = "termId长度不能超过8")
    private String termId;

    /**
     * 商户订单号, 商户系统内部的订单号 (5到30个字符、只能包含字母数字,区分大小写)
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "mchntOrderNo长度不能超过30")
    private String mchntOrderNo;

    /**
     * 订单类型: ALIPAY(统一下单、条码支付、服务窗支付) WECHAT(统一下单、条码支付、公众号支付、小程序) UNIONPAY BESTPAY(翼支付) PY68(银联分期-商户贴息) PY69(银联分期-持卡人贴息)
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 20, message = "orderType长度不能超过20")
    private String orderType;

    /**
     * 商户退款单号 (5到30个字符、只能包含字母数字或者下划线，区分大小写)
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "refundOrderNo长度不能超过30")
    private String refundOrderNo;

    /**
     * 总金额
     *
     * (必填)
     */
    @NotNull
    private Integer totalAmt;

    /**
     * 退款金额
     *
     * (必填)
     */
    @NotNull
    private Integer refundAmt;

    /**
     * 操作员
     *
     * (选填)
     */
    @Length(max = 32, message = "operatorId长度不能超过32")
    private String operatorId;

    /**
     * 富友终端号(富友终端号与TUSN号二选一)
     *
     * (选填)
     */
    @Length(max = 8, message = "reservedFyTermId长度不能超过8")
    private String reservedFyTermId;

    /**
     * 原交易日期(yyyyMMdd)！该值必定等于reserved_fy_settle_dt(富友接收交易时间。理论和合作方下单时间一致。微量跨日交易会不一致)。 不填该值，支持30天内的交易进行退款。 填写该值，支持90天。
     *
     * (选填)
     */
    @Length(max = 8, message = "reservedOrigiDt长度不能超过8")
    private String reservedOrigiDt;

    /**
     * 附加数据
     *
     * (选填)
     */
    @Length(max = 50, message = "reservedAddnInf长度不能超过50")
    private String reservedAddnInf;

}