/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.fuiou.request.merchant;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.fuiou.enums.merchant.FuiouMerchantApiDefinitionEnum;
import com.fshows.fuiou.request.base.FuiouBizRequest;
import com.fshows.fuiou.request.merchant.item.FuiouWechatConfigInfoRequest;
import com.fshows.fuiou.response.merchant.FuiouWechatConfigResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.List;

/**
 * @author
 * @version FuiouWechatConfigRequest.java, v 0.1 2023-09-16 09:32:01
 */
@Data
public class FuiouWechatConfigRequest extends FuiouBizRequest<FuiouWechatConfigResponse, FuiouMerchantApiDefinitionEnum> implements Serializable {

    private static final long serialVersionUID = -2213838555226125597L;


    /**
     * 唯一流水号
     * (必填)
     */
    @NotBlank
    @Length(max = 12, message = "traceNo长度不能超过12")
    private String traceNo;

    /**
     * 二级代理机构号
     * (选填)
     */
    @Length(max = 13, message = "subInsCd长度不能超过13")
    @JSONField(name = "sub_ins_cd")
    private String subInsCd;

    /**
     * 代理商类型(0：一般类，1：绿洲)
     * (必填)
     */
    @NotBlank
    @Length(max = 1, message = "agencyType长度不能超过1")
    private String agencyType;

    /**
     * 路由标记：为空或者 0 ；默认传1 为当前使用对应渠道微信参数
     * (选填)
     */
    @Length(max = 1, message = "channelFlag长度不能超过1")
    private String channelFlag;

    /**
     * 配置列表（参数如下）
     * (必填)
     */
    @NotEmpty
    private List<FuiouWechatConfigInfoRequest> configs;
}