/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.fuiou.request.merchant;

import com.fshows.fuiou.enums.merchant.FuiouMerchantApiDefinitionEnum;
import com.fshows.fuiou.request.base.FuiouBizRequest;
import com.fshows.fuiou.response.merchant.FuiouRateUploadResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author
 * @version FuiouRateUpdateRequest.java, v 0.1 2023-09-16 09:32:01
 */
@Data
public class FuiouRateUpdateRequest extends FuiouBizRequest<FuiouRateUploadResponse, FuiouMerchantApiDefinitionEnum> implements Serializable {

    private static final long serialVersionUID = -2213838555552344858L;


    /**
     * 唯一流水号
     * (必填)
     */
    @NotBlank
    @Length(max = 12, message = "traceNo长度不能超过12")
    private String traceNo;

    /**
     * 已在富友入网的富友商户代码
     * (必填)
     */
    @NotBlank
    @Length(max = 15, message = "fyMchntCd长度不能超过15")
    private String fyMchntCd;

    /**
     * 二级代理机构号
     * (选填)
     */
    @Length(max = 13, message = "subInsCd长度不能超过13")
    private String subInsCd;

    /**
     * 银联凭条打印名称
     * (必填)
     */
    @NotBlank
    @Length(max = 20, message = "printReceipt长度不能超过20")
    private String printReceipt;

    /**
     * 商户子类型（MCC）
     * (必填)
     */
    @NotBlank
    @Length(max = 4, message = "mchntSubTp长度不能超过4")
    private String mchntSubTp;

    /**
     * 商户英文名
     * (必填)
     */
    @NotBlank
    @Length(max = 128, message = "mchntEnName长度不能超过128")
    private String mchntEnName;

    /**
     * 商户简称英文名
     * (必填)
     */
    @NotBlank
    @Length(max = 25, message = "mchntEnShortname长度不能超过25")
    private String mchntEnShortname;

    /**
     * 是否开通pos(1开通，0关闭)
     * (必填)
     */
    @NotBlank
    @Length(max = 1, message = "isOpenPos长度不能超过1")
    private String isOpenPos;

    /**
     * 借记卡扣率（开通时必填）
     * (选填)
     */
    @Length(max = 5, message = "posDebitCardSetCd长度不能超过5")
    private String posDebitCardSetCd;

    /**
     * 贷记卡扣率（开通时必填）
     * (选填)
     */
    @Length(max = 5, message = "posCreditCardSetCd长度不能超过5")
    private String posCreditCardSetCd;

    /**
     * 借记卡活动扣率
     * (选填)
     */
    @Length(max = 5, message = "posActDebitCardSetCd长度不能超过5")
    private String posActDebitCardSetCd;

    /**
     * 贷记卡活动扣率
     * (选填)
     */
    @Length(max = 5, message = "posActCreditCardSetCd长度不能超过5")
    private String posActCreditCardSetCd;

    /**
     * 刷卡预授权(1开通，0关闭)
     * (必填)
     */
    @NotBlank
    @Length(max = 1, message = "posPreAuth长度不能超过1")
    private String posPreAuth;

    /**
     * 是否开通受理预付卡(1开通，0关闭)
     * (必填)
     */
    @NotBlank
    @Length(max = 1, message = "prepayAllowInd长度不能超过1")
    private String prepayAllowInd;

    /**
     * 预付卡费率
     * (选填)
     */
    @Length(max = 5, message = "prepaySetCd长度不能超过5")
    private String prepaySetCd;

    /**
     * 是否开通银联二维码(1开通，0关闭)
     * (必填)
     */
    @NotBlank
    @Length(max = 1, message = "cupQrpaySt长度不能超过1")
    private String cupQrpaySt;

    /**
     * 借记卡扣率（开通时必填）
     * (选填)
     */
    @Length(max = 5, message = "debitCardSetCd长度不能超过5")
    private String debitCardSetCd;

    /**
     * 贷记卡扣率（开通时必填）
     * (选填)
     */
    @Length(max = 5, message = "creditCardSetCd长度不能超过5")
    private String creditCardSetCd;

    /**
     * 借记卡活动扣率
     * (选填)
     */
    @Length(max = 5, message = "actDebitCardSetCd长度不能超过5")
    private String actDebitCardSetCd;

    /**
     * 贷记卡活动扣率
     * (选填)
     */
    @Length(max = 5, message = "actCreditCardSetCd长度不能超过5")
    private String actCreditCardSetCd;

}