/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fuiou.client.impl;

import cn.hutool.core.codec.Base64;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.asymmetric.Sign;
import com.fshows.fuiou.client.base.ApiClientConfig;
import com.fshows.fuiou.client.base.ISigner;
import com.fshows.fuiou.client.base.SignParam;
import com.fshows.fuiou.client.base.VerifySignParam;
import com.fshows.fuiou.exception.FuiouApiException;
import com.fshows.fuiou.request.base.FuiouBizRequest;
import com.fshows.fuiou.util.FuiouRequestUtils;
import com.fshows.fuiou.util.LogUtil;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSignerImpl
implements ISigner {
    private static final Logger log = LoggerFactory.getLogger(DefaultSignerImpl.class);

    @Override
    public String sign(SignParam signParam, ApiClientConfig apiClientConfig) throws FuiouApiException {
        return this.doSign(signParam, apiClientConfig);
    }

    @Override
    public Boolean verifySign(Map<String, String> resMap, VerifySignParam verifySignParam, ApiClientConfig apiClientConfig) throws FuiouApiException {
        try {
            String waitSignStr = DefaultSignerImpl.getWaitSignStr(resMap);
            LogUtil.info(log, "\u3010fuiou-sdk\u3011\u5f85\u9a8c\u7b7e\u5b57\u7b26\u4e32 >> waitSignStr={}", waitSignStr);
            String resSign = resMap.get("sign");
            Sign sign = new Sign(apiClientConfig.getSignTypeEnum().getAlgorithm(), SecureUtil.decode((String)apiClientConfig.getFubeiPrivateKey()), SecureUtil.decode((String)apiClientConfig.getFuiouPublicKey()));
            return sign.verify(waitSignStr.getBytes(apiClientConfig.getCharset()), Base64.decode((CharSequence)resSign));
        }
        catch (Exception e) {
            LogUtil.error(log, "\u3010fuiou-sdk\u3011fuiou\u54cd\u5e94\u7ed3\u679c\u9a8c\u7b7e\u5931\u8d25 >> signParam={}", e, verifySignParam);
            throw new FuiouApiException("fuiou\u54cd\u5e94\u7ed3\u679c\u9a8c\u7b7e\u5931\u8d25", e);
        }
    }

    public String doSign(SignParam signParam, ApiClientConfig apiClientConfig) throws FuiouApiException {
        try {
            FuiouBizRequest request = signParam.getRequest();
            Map<String, String> data = FuiouRequestUtils.toMap(request);
            String waitSignStr = DefaultSignerImpl.getWaitSignStr(data);
            LogUtil.info(log, "\u3010fuiou-sdk\u3011\u5f85\u52a0\u7b7e\u5b57\u7b26\u4e32 >> waitSignStr={}", waitSignStr);
            Sign sign = new Sign(apiClientConfig.getSignTypeEnum().getAlgorithm(), SecureUtil.decode((String)apiClientConfig.getFubeiPrivateKey()), null);
            byte[] signed = sign.sign(waitSignStr.getBytes(apiClientConfig.getCharset()));
            return Base64.encode((byte[])signed);
        }
        catch (Exception e) {
            LogUtil.error(log, "\u3010fuiou-sdk\u3011fuiou\u8bf7\u6c42\u52a0\u7b7e\u5931\u8d25 >> signParam={}", e, signParam);
            throw new FuiouApiException("\u8bf7\u6c42\u52a0\u7b7e\u5931\u8d25", e);
        }
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        String algorithm = "MD5WithRSA";
        String privateKey = "MIICdQIBADANBgkqhkiG9w0BAQEFAASCAl8wggJbAgEAAoGBAMKz4ubO5o9ZV37dqYEbh30ZjULO\nkJIxuIa+P8OhZJKcTX0ue9oAOXjqG5JCShKotEw+YZoVhsjFp+DTscqATIfXucrkkZ/FTLdMP2tg\nIZ3seMybJoHtDlG8dzZHZNMu7LbrfXYN7vs7sTQXzCmqGp7qS98kknNdBVqhZ6zO9TPfAgMBAAEC\ngYBhqi5FLL/GZEBZaQMfuhlqjSiovEkUrFAtdr0xeoGicTkFdA24OqiZmIUgBpR1a56VKC15RxcH\nGu6s/kOOmnDIS0fakWRLeT70JyFXQA2CC7zvMTzA5SsZpQyZZ219Bgw+g4UO74B1yolSYj1+67hT\nCcjlhZxXokSIjFybXY4ccQJBAOTOd6JNp4q9umg1Ig9/8p/k6umAYCVGRAz/gqX3v658cF4653oY\ndrux/6BoLGtq1wTxYWbWjgyhO44sIjvZrssCQQDZ18u8AW2aRt3RmpESa6vRp7doUvZj3s04jbCD\n87MdL+62eUhY4I2adw9e/HCsqjb9Iu0kdxfNXEvsTXhF8Hi9AkAF9ouPo052gzNUe+4DUWZVXHXy\n1/GphwdG/3G8OZS5S2zyR764o+KUSbNLzus5cXNhIZlUQMs68QjIT8YkoSu5AkBIoqeP/HnrIw37\nQap1lekoct+4rVDyY+vRm4zrsmpapQzXUwFIgTc19dTuOwXmzKqhJPAlZIBPPSMjm4Eq8M+RAkA5\nJP3lE36NOQxcqLzza9UVAzR+sExE0uy9iAxTlxs9NzdxNGPfjkIPYnAVEApR5+s0eCYEC1fuE82g\nknHIEE6/";
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("name", "111111");
        map.put("age", "222222");
        String waitSignStr = DefaultSignerImpl.getWaitSignStr(map);
        System.out.println(waitSignStr + "\n\n\n");
        Sign sign = new Sign(algorithm, SecureUtil.decode((String)privateKey), null);
        byte[] signed = sign.sign(waitSignStr.getBytes("GBK"));
        String signStr = Base64.encode((byte[])signed);
        System.out.println(signStr);
        map.put("sign", signStr);
        System.out.println("\n\n\n" + FuiouRequestUtils.generateXml(map));
    }

    public static String getWaitSignStr(Map<String, String> dataMap) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : dataMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (StringUtils.equals((CharSequence)key, (CharSequence)"sign") || StringUtils.startsWith((CharSequence)key, (CharSequence)"reserved")) continue;
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(key).append("=").append(StringUtils.defaultString((String)value, (String)""));
        }
        return sb.toString();
    }
}

